/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.parse;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.parse.EglLexer;
import org.eclipse.epsilon.egl.parse.EglRecognitionException;
import org.eclipse.epsilon.egl.parse.EglToken;

public class EglParser {
    private final EglLexer lexer;
    private final List<ParseProblem> problems = new LinkedList<ParseProblem>();
    private final EpsilonTreeAdaptor astFactory;
    private ParseProblem lastError = null;
    private EglToken current;
    private AST ast;

    public EglParser(EglLexer lexer, EpsilonTreeAdaptor astFactory) {
        if (lexer == null) {
            throw new NullPointerException("program cannot be null");
        }
        this.lexer = lexer;
        this.astFactory = astFactory;
        this.ast = this.createAST(EglToken.TokenType.PROGRAM, "", 1, 1);
    }

    public AST getAST() {
        return this.ast;
    }

    public List<ParseProblem> getParseProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public boolean parse() {
        try {
            this.nextToken();
            return this.parseProgram();
        }
        catch (EglRecognitionException e) {
            this.problems.add(new ParseProblem(e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
            return false;
        }
    }

    private void nextToken() throws EglRecognitionException {
        this.current = this.lexer.nextToken();
    }

    private boolean parseProgram() throws EglRecognitionException {
        while (true) {
            if (this.current.getTokenType() == EglToken.TokenType.EOF) {
                return true;
            }
            AST commentedAst = this.parseCommented();
            if (commentedAst != null) {
                this.ast.addChild(commentedAst);
                continue;
            }
            AST taggedAst = this.parseTagged();
            if (taggedAst != null) {
                this.ast.addChild(taggedAst);
                continue;
            }
            AST textAst = this.parseText();
            if (textAst == null) break;
            this.ast.addChild(textAst);
        }
        return false;
    }

    private AST parseText() throws EglRecognitionException {
        StringBuilder text = new StringBuilder();
        int line = -1;
        int col = -1;
        while (this.current.getTokenType() == EglToken.TokenType.PLAIN_TEXT) {
            if (line == -1) {
                line = this.current.getLine();
                col = this.current.getColumn();
            }
            text.append(this.current.getText());
            this.nextToken();
        }
        if (text.toString().length() > 0) {
            return this.createAST(EglToken.TokenType.PLAIN_TEXT, text.toString(), line, col);
        }
        if (this.current.getTokenType() == EglToken.TokenType.NEW_LINE) {
            AST newLineAST = this.createAST(this.current);
            this.nextToken();
            return newLineAST;
        }
        this.reportError(EglToken.TokenType.PLAIN_TEXT);
        return null;
    }

    private AST parseTagged() throws EglRecognitionException {
        EglToken startTagToken = this.current;
        if (this.current.getTokenType() != EglToken.TokenType.START_TAG && this.current.getTokenType() != EglToken.TokenType.START_OUTPUT_TAG) {
            return null;
        }
        this.nextToken();
        LinkedList<AST> textAsts = new LinkedList<AST>();
        AST next = null;
        do {
            if ((next = this.parseText()) == null) continue;
            textAsts.add(next);
        } while (next != null && this.current.getTokenType() != EglToken.TokenType.END_TAG);
        if (textAsts.size() == 0) {
            return null;
        }
        if (this.current.getTokenType() == EglToken.TokenType.END_TAG) {
            AST endTag = this.createAST(this.current);
            AST taggedAst = this.createAST(startTagToken);
            for (AST textAst : textAsts) {
                taggedAst.addChild(textAst);
            }
            taggedAst.addChild(endTag);
            this.nextToken();
            return taggedAst;
        }
        return null;
    }

    private AST parseCommented() throws EglRecognitionException {
        EglToken startCommentTagToken = this.current;
        if (this.current.getTokenType() != EglToken.TokenType.START_COMMENT_TAG && this.current.getTokenType() != EglToken.TokenType.START_MARKER_TAG) {
            return null;
        }
        this.nextToken();
        StringBuilder commentContents = new StringBuilder();
        while (this.current != null && this.current.getTokenType() != EglToken.TokenType.END_COMMENT_TAG && this.current.getTokenType() != EglToken.TokenType.EOF) {
            commentContents.append(this.current.getText());
            this.nextToken();
        }
        if (this.current.getTokenType() == EglToken.TokenType.END_COMMENT_TAG) {
            AST endCommentTag = this.createAST(this.current);
            AST commentedAst = this.createAST(startCommentTagToken);
            commentedAst.addChild(this.createAST(EglToken.TokenType.PLAIN_TEXT, commentContents.toString(), startCommentTagToken.getLine(), startCommentTagToken.getColumn() + startCommentTagToken.getText().length()));
            commentedAst.addChild(endCommentTag);
            this.nextToken();
            return commentedAst;
        }
        return null;
    }

    private AST createAST(EglToken t) {
        return this.astFactory.create(t);
    }

    private AST createAST(EglToken.TokenType type, String text, int line, int col) {
        return this.astFactory.create(new EglToken(type, text, line, col));
    }

    private void reportError(EglToken.TokenType expectedType) {
        if (this.lastError == null || this.lastError.getColumn() != this.current.getColumn() || this.lastError.getLine() != this.current.getLine()) {
            this.lastError = new ParseProblem(this.current.getLine(), this.current.getColumn(), "Unexpected token '" + (Object)((Object)this.current.getTokenType()) + "' " + "(was expecting '" + (Object)((Object)expectedType) + "')");
            this.problems.add(this.lastError);
        }
    }
}

