/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.execute.operations;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.evl.EvlConstraint;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.execute.exceptions.EvlConstraintNotFoundException;

public class SatisfiesOperation
extends AbstractOperation {
    protected boolean all = true;

    public SatisfiesOperation(boolean all) {
        this.all = all;
    }

    @Override
    public Object execute(Object obj, AST ast, IEolContext context_) throws EolRuntimeException {
        if (obj == null) {
            return false;
        }
        IEvlContext context = (IEvlContext)context_;
        for (AST child : ast.getFirstChild().getChildren()) {
            Object result = context.getExecutorFactory().executeAST(child, context);
            String constraintName = context.getPrettyPrinterManager().toString(result);
            EvlConstraint constraint = context.getModule().getConstraints().getConstraint(constraintName, obj, context);
            if (constraint == null) {
                throw new EvlConstraintNotFoundException(constraintName, ast);
            }
            boolean valid = constraint.check(obj, context);
            if (this.all) {
                if (valid) continue;
                return false;
            }
            if (!valid) continue;
            return true;
        }
        return true;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }
}

