/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.execution;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.EolContext;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;

public class EolExecutor {
    private final EolContext context;

    public EolExecutor(EolContext context) {
        this.context = context;
    }

    public boolean executeGuard(AST guard, Variable originalVar) throws FlockRuntimeException {
        this.context.getFrameStack().enterLocal(FrameType.PROTECTED, guard, originalVar);
        Boolean guardSatisfied = (Boolean)this.context.getExecutorFactory().executeBlockOrExpressionAst(guard, this.context, false);
        this.context.getFrameStack().leaveLocal(guard);
        return guardSatisfied;
    }

    public Object executeBlock(AST block, Variable ... variables) throws FlockRuntimeException {
        try {
            this.context.getFrameStack().enterLocal(FrameType.PROTECTED, block, variables);
            Object result = this.context.getExecutorFactory().executeAST(block, this.context);
            this.context.getFrameStack().leaveLocal(block);
            return result;
        }
        catch (EolRuntimeException e) {
            e.printStackTrace();
            throw new FlockRuntimeException("Exception encountered while executing EOL block.", e);
        }
    }
}

