/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.parser.sax;

import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.xmi.parser.generator.SpecGenerator;
import org.eclipse.epsilon.hutn.xmi.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SpecGeneratingContentHandler
extends DefaultHandler {
    private final SpecGenerator generator = new SpecGenerator();
    private Locator locator;
    private boolean skipPopOnNextEndElement = false;
    private String currentElementName;

    public Spec getSpec() {
        return this.generator.getSpec();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private int getCurrentLineNumber() {
        return this.locator.getLineNumber();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if ("xmi".equals(prefix) || "xsi".equals(prefix)) {
            return;
        }
        this.generator.initialise(uri);
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        this.currentElementName = name;
        if (!this.generator.hasCurrentClassObject()) {
            if (qName.equals("xmi:XMI")) {
                return;
            }
            this.generator.generateTopLevelClassObject(atts.getValue("xmi:id"), name, this.getCurrentLineNumber());
        } else if (atts.getIndex("href") >= 0) {
            this.generator.addAttributeValue(name, atts.getValue("href"), this.getCurrentLineNumber());
            this.skipPopOnNextEndElement = true;
        } else if (atts.getIndex("xsi:type") >= 0) {
            this.generator.generateContainedClassObject(name, atts.getValue("xmi:id"), SpecGeneratingContentHandler.getLocalName(atts.getValue("xsi:type")), this.getCurrentLineNumber());
        } else {
            this.generator.generateContainedClassObject(name, atts.getValue("xmi:id"), this.getCurrentLineNumber());
        }
        this.processAttributes(atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length);
        if (StringUtil.isNotWhitespace(text)) {
            this.processMultiValuedAttribute(text);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.generator.hasCurrentClassObject() && !this.skipPopOnNextEndElement) {
            this.generator.stopGeneratingCurrentClassObject();
        }
        this.skipPopOnNextEndElement = false;
    }

    private void processMultiValuedAttribute(String value) {
        this.generator.stopGeneratingAndDeleteCurrentClassObject();
        this.skipPopOnNextEndElement = true;
        this.generator.addAttributeValue(this.currentElementName, value, this.getCurrentLineNumber());
    }

    private void processAttributes(Attributes atts) {
        int index = 0;
        while (index < atts.getLength()) {
            if (!this.attributeIsMetadata(atts.getQName(index))) {
                this.generator.addAttributeValue(atts.getLocalName(index), atts.getValue(index), this.getCurrentLineNumber());
            }
            ++index;
        }
    }

    private boolean attributeIsMetadata(String attributeName) {
        return attributeName.equals("href") || attributeName.startsWith("xmi") || attributeName.startsWith("xsi");
    }

    private static String getLocalName(String qualifiedName) {
        return qualifiedName.split(":")[1];
    }
}

