/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDNamedComponentImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSDUtil
extends XSDConstants {
    public static XSDSchema getSchemaForSchema(String schemaForSchemaURI) {
        return XSDSchemaImpl.getSchemaForSchema(schemaForSchemaURI);
    }

    public static XSDNamedComponent findInSortedList(List<? extends XSDNamedComponent> xsdNamedComponents, String namespace, String name) {
        return XSDNamedComponentImpl.findInSortedList(xsdNamedComponents, namespace, name);
    }

    public static List<XSDDiagnostic> checkComplexContent(XSDSchema schema, String complexTypeName, String part, String anchor, Element element) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = schema.resolveComplexTypeDefinition(complexTypeName);
        return XSDUtil.checkComplexContent(xsdComplexTypeDefinition, part, anchor, element);
    }

    public static List<XSDDiagnostic> checkComplexContent(XSDComplexTypeDefinition xsdComplexTypeDefinition, String part, String anchor, Element element) {
        boolean incompleteContent;
        ArrayList<XSDDiagnostic> result = new ArrayList<XSDDiagnostic>();
        XSDParticle complexType = xsdComplexTypeDefinition.getComplexType();
        boolean mixed = xsdComplexTypeDefinition.isMixed();
        XSDParticle.DFA dfa = complexType.getDFA();
        XSDParticle.DFA.State state = dfa.getInitialState();
        XSDFactory xsdFactory = XSDPackage.eINSTANCE.getXSDFactory();
        boolean invalidContentDetected = false;
        Node child = element.getFirstChild();
        while (child != null) {
            block0 : switch (child.getNodeType()) {
                case 1: {
                    if (invalidContentDetected) break;
                    XSDParticle.DFA.Transition transition = state.accept(child.getNamespaceURI(), child.getLocalName());
                    if (transition != null) {
                        state = transition.getState();
                        break;
                    }
                    XSDDiagnostic xsdDiagnostic = xsdFactory.createXSDDiagnostic();
                    xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
                    xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDUtil.populateDiagnostic(xsdDiagnostic, "content-valid.1", new Object[]{XSDConstants.uri(child), xsdComplexTypeDefinition.getURI(), XSDUtil.getExpected(state)})}));
                    xsdDiagnostic.setAnnotationURI(String.valueOf(part) + "#" + anchor);
                    xsdDiagnostic.setNode(child);
                    result.add(xsdDiagnostic);
                    invalidContentDetected = true;
                    break;
                }
                case 3: 
                case 4: {
                    String text;
                    if (mixed || (text = child.getNodeValue()) == null) break;
                    int i = 0;
                    int length = text.length();
                    while (i < length) {
                        char character = text.charAt(i);
                        if (character != '\n' && character != '\r' && character != ' ' && character != '\t') {
                            XSDDiagnostic xsdDiagnostic = xsdFactory.createXSDDiagnostic();
                            xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
                            xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDUtil.populateDiagnostic(xsdDiagnostic, "content-valid.3", new Object[]{text.substring(i), xsdComplexTypeDefinition.getURI()})}));
                            xsdDiagnostic.setAnnotationURI(String.valueOf(part) + "#" + anchor);
                            xsdDiagnostic.setNode(child);
                            result.add(xsdDiagnostic);
                            break block0;
                        }
                        ++i;
                    }
                    break;
                }
            }
            child = child.getNextSibling();
        }
        boolean bl = incompleteContent = !invalidContentDetected && !state.isAccepting();
        if (incompleteContent) {
            XSDDiagnostic xsdDiagnostic = xsdFactory.createXSDDiagnostic();
            xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
            xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDUtil.populateDiagnostic(xsdDiagnostic, "content-valid.2", new Object[]{xsdComplexTypeDefinition.getURI(), XSDUtil.getExpected(state)})}));
            xsdDiagnostic.setAnnotationURI(String.valueOf(part) + "#" + anchor);
            xsdDiagnostic.setNode(element);
            result.add(xsdDiagnostic);
        }
        return result;
    }

    private static String getExpected(XSDParticle.DFA.State state) {
        StringBuffer result = new StringBuffer();
        for (XSDParticle.DFA.Transition transition : state.getTransitions()) {
            XSDParticle xsdParticle = transition.getParticle();
            XSDTerm xsdTerm = xsdParticle.getTerm();
            if (xsdTerm instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                if (result.length() != 0) {
                    result.append(" | ");
                }
                result.append(xsdElementDeclaration.getName());
                continue;
            }
            if (!(xsdTerm instanceof XSDWildcard)) continue;
            XSDWildcard xsdWildcard = (XSDWildcard)xsdTerm;
            if (result.length() != 0) {
                result.append(" | ");
            }
            result.append(xsdWildcard.getStringLexicalNamespaceConstraint());
        }
        if (state.isAccepting()) {
            if (result.length() != 0) {
                result.append(" | ");
            }
            result.append(XSDPlugin.INSTANCE.getString("expecting_nothing"));
        }
        return result.length() == 0 ? XSDPlugin.INSTANCE.getString("expecting_nothing") : result.toString();
    }

    private static String populateDiagnostic(XSDDiagnostic xsdDiagnostic, String key, Object[] substitutions) {
        xsdDiagnostic.setKey(key);
        if (substitutions != null) {
            EList<String> values = xsdDiagnostic.getSubstitutions();
            int i = 0;
            while (i < substitutions.length) {
                Object value = substitutions[i];
                values.add(value == null ? null : value.toString());
                ++i;
            }
            return XSDPlugin.INSTANCE.getString(key, substitutions);
        }
        return XSDPlugin.INSTANCE.getString(key);
    }

    public static interface ByteSequence {
        public byte[] getBytes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URICrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;
        protected String[] uris;

        protected URICrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected URICrossReferencer(Resource resource) {
            super(resource);
        }

        protected URICrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected URICrossReferencer(Collection<?> emfObjects) {
            super(emfObjects);
        }

        @Override
        protected boolean containment(EObject eObject) {
            if (eObject instanceof XSDNamedComponent) {
                XSDNamedComponent xsdNamedComponent = (XSDNamedComponent)eObject;
                int i = 0;
                while (i < this.uris.length) {
                    String uri = this.uris[i];
                    if (xsdNamedComponent.hasURI(uri)) {
                        this.getCollection(eObject);
                        break;
                    }
                    ++i;
                }
            }
            return true;
        }

        @Override
        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            if (crossReferencedEObject instanceof XSDNamedComponent && !eReference.isVolatile() && eReference.isChangeable()) {
                XSDNamedComponent xsdNamedComponent = (XSDNamedComponent)crossReferencedEObject;
                int i = 0;
                while (i < this.uris.length) {
                    String uri = this.uris[i];
                    if (xsdNamedComponent.hasURI(uri)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        protected Map<EObject, Collection<EStructuralFeature.Setting>> findURI(String uri) {
            this.uris = new String[]{uri};
            this.crossReference();
            this.uris = null;
            this.done();
            return this;
        }

        protected Map<EObject, Collection<EStructuralFeature.Setting>> findAllURI(Collection<String> uris) {
            this.uris = uris.toArray(new String[uris.size()]);
            this.crossReference();
            uris = null;
            this.done();
            return this;
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(String uri, EObject eObject) {
            return new URICrossReferencer(eObject).findURI(uri);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(String uri, Resource resource) {
            return new URICrossReferencer(resource).findURI(uri);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(String uri, ResourceSet resourceSet) {
            return new URICrossReferencer(resourceSet).findURI(uri);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(String uri, Collection<?> emfObjectsToSearch) {
            return new URICrossReferencer(emfObjectsToSearch).findURI(uri);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> findAll(Collection<String> uris, EObject eObject) {
            return new URICrossReferencer(eObject).findAllURI(uris);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> findAll(Collection<String> uris, Resource resource) {
            return new URICrossReferencer(resource).findAllURI(uris);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> findAll(Collection<String> uris, ResourceSet resourceSet) {
            return new URICrossReferencer(resourceSet).findAllURI(uris);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> findAll(Collection<String> uris, Collection<?> emfObjectsToSearch) {
            return new URICrossReferencer(emfObjectsToSearch).findAllURI(uris);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UsageCrossReferencer
    extends EcoreUtil.UsageCrossReferencer {
        private static final long serialVersionUID = 1L;
        protected Collection<?> eObjectsOfInterest;

        protected UsageCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected UsageCrossReferencer(Resource resource) {
            super(resource);
        }

        protected UsageCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected UsageCrossReferencer(Collection<?> emfObjects) {
            super(emfObjects);
        }

        @Override
        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return !eReference.isVolatile() && eReference.isChangeable() && this.eObjectsOfInterest.contains(crossReferencedEObject);
        }

        @Override
        protected Collection<EStructuralFeature.Setting> findUsage(EObject eObject) {
            this.eObjectsOfInterest = Collections.singleton(eObject);
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this.getCollection(eObject);
        }

        @Override
        protected Map<EObject, Collection<EStructuralFeature.Setting>> findAllUsage(Collection<?> eObjectsOfInterest) {
            this.eObjectsOfInterest = eObjectsOfInterest;
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this;
        }

        public static Collection<EStructuralFeature.Setting> find(EObject eObjectOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findUsage(eObjectOfInterest);
        }

        public static Collection<EStructuralFeature.Setting> find(EObject eObjectOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findUsage(eObjectOfInterest);
        }

        public static Collection<EStructuralFeature.Setting> find(EObject eObjectOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findUsage(eObjectOfInterest);
        }

        public static Collection<EStructuralFeature.Setting> find(EObject eObjectOfInterest, Collection<?> emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findUsage(eObjectOfInterest);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> findAll(Collection<?> eObjectsOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findAllUsage(eObjectsOfInterest);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> findAll(Collection<?> eObjectsOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findAllUsage(eObjectsOfInterest);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> findAll(Collection<?> eObjectsOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findAllUsage(eObjectsOfInterest);
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> findAll(Collection<?> eObjectsOfInterest, Collection<?> emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findAllUsage(eObjectsOfInterest);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XSDNamedComponentCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;

        protected XSDNamedComponentCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected XSDNamedComponentCrossReferencer(Resource resource) {
            super(resource);
        }

        protected XSDNamedComponentCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected XSDNamedComponentCrossReferencer(Collection<?> emfObjects) {
            super(emfObjects);
        }

        @Override
        protected boolean containment(EObject eObject) {
            if (eObject instanceof XSDNamedComponent) {
                this.getCollection(eObject);
            }
            return true;
        }

        @Override
        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return !eReference.isVolatile() && eReference.isChangeable() && crossReferencedEObject instanceof XSDNamedComponent;
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(EObject eObject) {
            XSDNamedComponentCrossReferencer result = new XSDNamedComponentCrossReferencer(eObject);
            result.crossReference();
            result.done();
            return result;
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(Resource resource) {
            XSDNamedComponentCrossReferencer result = new XSDNamedComponentCrossReferencer(resource);
            result.crossReference();
            result.done();
            return result;
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(ResourceSet resourceSet) {
            XSDNamedComponentCrossReferencer result = new XSDNamedComponentCrossReferencer(resourceSet);
            result.crossReference();
            result.done();
            return result;
        }
    }
}

