/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Arrays;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.functions.RBFModel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.WeightedInstancesHandler;

public class RBFRegressor
extends RBFModel
implements WeightedInstancesHandler {
    private static final long serialVersionUID = -7847474276438394611L;

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    protected void initializeOutputLayer(Random random) {
        for (int i = 0; i < this.m_numUnits + 1; ++i) {
            this.m_RBFParameters[this.OFFSET_WEIGHTS + i] = (random.nextDouble() - 0.5) / 2.0;
        }
    }

    @Override
    protected double calculateError(double[] outputs, Instance inst) {
        double err = this.getOutput(outputs) - inst.classValue();
        return inst.weight() * err * err;
    }

    @Override
    protected double postprocessError(double error) {
        double squaredSumOfWeights = 0.0;
        for (int k = 0; k < this.m_numUnits; ++k) {
            squaredSumOfWeights += this.m_RBFParameters[this.OFFSET_WEIGHTS + k] * this.m_RBFParameters[this.OFFSET_WEIGHTS + k];
        }
        return error + this.m_ridge * squaredSumOfWeights;
    }

    @Override
    protected void postprocessGradient(double[] grad) {
        for (int k = 0; k < this.m_numUnits; ++k) {
            int n = this.OFFSET_WEIGHTS + k;
            grad[n] = grad[n] + this.m_ridge * 2.0 * this.m_RBFParameters[this.OFFSET_WEIGHTS + k];
        }
    }

    @Override
    protected void updateGradient(double[] grad, Instance inst, double[] outputs, double[] derivativesOutputs, double[] deltaHidden) {
        int i;
        Arrays.fill(deltaHidden, 0.0);
        double deltaOut = inst.weight() * (this.getOutput(outputs) - inst.classValue());
        if (deltaOut <= this.m_tolerance && deltaOut >= -this.m_tolerance) {
            return;
        }
        int offsetOW = this.OFFSET_WEIGHTS;
        for (i = 0; i < this.m_numUnits; ++i) {
            int n = i;
            deltaHidden[n] = deltaHidden[n] + deltaOut * this.m_RBFParameters[offsetOW + i];
        }
        for (i = 0; i < this.m_numUnits; ++i) {
            int n = offsetOW + i;
            grad[n] = grad[n] + deltaOut * outputs[i];
        }
        int n = offsetOW + this.m_numUnits;
        grad[n] = grad[n] + deltaOut;
    }

    protected double getOutput(double[] outputs) {
        double result = 0.0;
        for (int i = 0; i < this.m_numUnits; ++i) {
            result += this.m_RBFParameters[this.OFFSET_WEIGHTS + i] * outputs[i];
        }
        return result += this.m_RBFParameters[this.OFFSET_WEIGHTS + this.m_numUnits];
    }

    @Override
    protected double[] getDistribution(double[] outputs) {
        double[] dist = new double[]{this.getOutput(outputs) * this.m_x1 + this.m_x0};
        return dist;
    }

    public String toString() {
        if (this.m_RBFParameters == null) {
            return "Classifier not built yet.";
        }
        String s = "";
        for (int i = 0; i < this.m_numUnits; ++i) {
            int j;
            s = s + "\n\nOutput weight: " + this.m_RBFParameters[this.OFFSET_WEIGHTS + i];
            s = s + "\n\nUnit center:\n";
            for (j = 0; j < this.m_numAttributes; ++j) {
                if (j == this.m_classIndex) continue;
                s = s + this.m_RBFParameters[this.OFFSET_CENTERS + i * this.m_numAttributes + j] + "\t";
            }
            if (this.m_scaleOptimizationOption == 3) {
                s = s + "\n\nUnit scales:\n";
                for (j = 0; j < this.m_numAttributes; ++j) {
                    if (j == this.m_classIndex) continue;
                    s = s + this.m_RBFParameters[this.OFFSET_SCALES + i * this.m_numAttributes + j] + "\t";
                }
                continue;
            }
            if (this.m_scaleOptimizationOption != 2) continue;
            s = s + "\n\nUnit scale:\n";
            s = s + this.m_RBFParameters[this.OFFSET_SCALES + i] + "\t";
        }
        if (this.m_scaleOptimizationOption == 1) {
            s = s + "\n\nScale:\n";
            s = s + this.m_RBFParameters[this.OFFSET_SCALES] + "\t";
        }
        if (this.m_useAttributeWeights) {
            s = s + "\n\nAttribute weights:\n";
            for (int j = 0; j < this.m_numAttributes; ++j) {
                if (j == this.m_classIndex) continue;
                s = s + this.m_RBFParameters[this.OFFSET_ATTRIBUTE_WEIGHTS + j] + "\t";
            }
        }
        s = s + "\n\nBias weight: " + this.m_RBFParameters[this.OFFSET_WEIGHTS + this.m_numUnits];
        return s;
    }

    public static void main(String[] argv) {
        RBFRegressor.runClassifier((Classifier)new RBFRegressor(), (String[])argv);
    }
}

