/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.traceability.Variable;
import org.eclipse.epsilon.eol.execute.context.FrameStack;

public class ExecutableTemplateSpecification {
    public EglTemplate template;
    public IOutputBuffer outputBuffer;

    public ExecutableTemplateSpecification(EglTemplate template, IOutputBuffer outputBuffer) {
        this.template = template;
        this.outputBuffer = outputBuffer;
    }

    public void addAsChild(ExecutableTemplateSpecification child) {
        this.template.getTemplate().add(child.template.getTemplate());
    }

    public void addVariablesTo(FrameStack frameStack) {
        this.addOutAsGlobalVariable(frameStack);
        this.addTemplateVariablesAsLocalVariables(frameStack);
    }

    private void addOutAsGlobalVariable(FrameStack frameStack) {
        frameStack.putGlobal(this.createEolVariable("out", this.outputBuffer));
    }

    private void addTemplateVariablesAsLocalVariables(FrameStack frameStack) {
        for (Variable variable : this.template.getTemplate().getVariables()) {
            frameStack.put(this.createEolVariable(variable.getName(), variable.getValue()));
        }
    }

    private org.eclipse.epsilon.eol.execute.context.Variable createEolVariable(String name, Object value) {
        return org.eclipse.epsilon.eol.execute.context.Variable.createReadOnlyVariable(name, value);
    }

    public String toString() {
        return this.template.getTemplate().toString();
    }
}

