/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.evl.EvlConstraint;
import org.eclipse.epsilon.evl.EvlConstraintContext;
import org.eclipse.epsilon.evl.EvlConstraints;
import org.eclipse.epsilon.evl.IEvlFixer;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.execute.EvlOperationFactory;
import org.eclipse.epsilon.evl.execute.context.EvlContext;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.parse.EvlLexer;
import org.eclipse.epsilon.evl.parse.EvlParser;

public class EvlModule
extends ErlModule
implements IEvlModule {
    protected IEvlFixer fixer = null;
    protected ArrayList<EvlConstraintContext> declaredConstraintContexts = new ArrayList();
    protected ArrayList<EvlConstraintContext> constraintContexts;
    protected EvlConstraints constraints = new EvlConstraints();
    protected IEvlContext context = null;

    public EvlModule() {
        this.reset();
    }

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EvlLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EvlParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "evlModule";
    }

    @Override
    public HashMap<String, Class<?>> getImportConfiguration() {
        HashMap<String, Class<?>> importConfiguration = super.getImportConfiguration();
        importConfiguration.put("evl", EvlModule.class);
        return importConfiguration;
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        for (AST matchRuleAst : AstUtil.getChildren(this.ast, 82)) {
            EvlConstraintContext constraintContext = new EvlConstraintContext();
            constraintContext.build(matchRuleAst);
            this.declaredConstraintContexts.add(constraintContext);
        }
        for (EvlConstraintContext constraintContext : this.getConstraintContexts()) {
            for (EvlConstraint constraint : constraintContext.getConstraints()) {
                this.constraints.addConstraint(constraint);
            }
        }
    }

    public ArrayList<EvlConstraintContext> getDeclaredConstraintContexts() {
        return this.declaredConstraintContexts;
    }

    public ArrayList<EvlConstraintContext> getConstraintContexts() {
        if (this.constraintContexts == null) {
            this.constraintContexts = new ArrayList();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEvlModule)) continue;
                IEvlModule module = (IEvlModule)import_.getModule();
                this.constraintContexts.addAll(module.getConstraintContexts());
            }
            this.constraintContexts.addAll(this.declaredConstraintContexts);
        }
        return this.constraintContexts;
    }

    @Override
    public Object execute() throws EolRuntimeException {
        this.prepareContext(this.context);
        this.context.setOperationFactory(new EvlOperationFactory());
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("constraintTrace", this.context.getConstraintTrace()));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("thisModule", this));
        this.execute(this.getPre(), this.context);
        for (EvlConstraintContext constraintContext : this.getConstraintContexts()) {
            constraintContext.checkAll(this.context);
        }
        if (this.fixer != null) {
            this.fixer.fix(this);
        }
        this.execute(this.getPost(), this.context);
        return null;
    }

    @Override
    public IEvlContext getContext() {
        return this.context;
    }

    @Override
    public EvlConstraints getConstraints() {
        return this.constraints;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll(this.getDeclaredPre());
        children.addAll(this.getDeclaredConstraintContexts());
        children.addAll(this.getDeclaredOperations());
        children.addAll(this.getDeclaredPost());
        return children;
    }

    @Override
    public void reset() {
        super.reset();
        this.constraintContexts = null;
        this.declaredConstraintContexts = new ArrayList();
        this.context = new EvlContext();
    }

    @Override
    public void setUnsatisfiedConstraintFixer(IEvlFixer fixer) {
        this.fixer = fixer;
    }

    @Override
    public IEvlFixer getUnsatisfiedConstraintFixer() {
        return this.fixer;
    }

    @Override
    protected int getPostBlockTokenType() {
        return 77;
    }

    @Override
    protected int getPreBlockTokenType() {
        return 76;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof IEvlContext) {
            this.context = (IEvlContext)context;
        }
    }
}

