/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.execution;

import org.eclipse.epsilon.flock.FlockExecution;
import org.eclipse.epsilon.flock.context.EquivalenceEstablishmentContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.equivalences.factory.EquivalenceFactory;
import org.eclipse.epsilon.flock.execution.EolExecutor;
import org.eclipse.epsilon.flock.execution.GuardedConstructContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;

public class TypeMappingContext {
    private final ModelElement original;
    private final EolExecutor executor;
    private final FlockExecution execution;
    private final EquivalenceEstablishmentContext.EquivalentFactory equivalentFactory;

    public TypeMappingContext(ModelElement original, EolExecutor executor, FlockExecution execution, EquivalenceEstablishmentContext.EquivalentFactory equivalentFactory) {
        this.original = original;
        this.executor = executor;
        this.execution = execution;
        this.equivalentFactory = equivalentFactory;
    }

    public boolean isEligibleFor(TypeMappingConstruct typeMapping) throws FlockRuntimeException {
        return typeMapping.appliesIn(this.getOriginal());
    }

    private GuardedConstructContext getOriginal() {
        return new GuardedConstructContext(this.original, this.executor);
    }

    public Equivalence createEquivalenceUsing(EquivalenceFactory equivalenceFactory) throws FlockRuntimeException {
        return equivalenceFactory.createEquivalence(this.executor, this.execution, this.original, this.equivalentFactory);
    }
}

