/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleArrayListParameter;
import java.util.ArrayList;
import java.util.List;

public class PredefinedInitialMeans
extends AbstractKMeansInitialization<NumberVector> {
    List<? extends NumberVector> initialMeans;

    public PredefinedInitialMeans(List<? extends NumberVector> list) {
        super(null);
        this.setInitialMeans(list);
    }

    public PredefinedInitialMeans(double[][] dArray) {
        super(null);
        this.setInitialMeans(dArray);
    }

    public void setInitialMeans(List<? extends NumberVector> list) {
        this.initialMeans = list;
    }

    public void setInitialClusters(List<? extends Cluster<? extends MeanModel>> list) {
        ArrayList<? extends NumberVector> arrayList = new ArrayList<NumberVector>(list.size());
        for (Cluster<? extends MeanModel> cluster : list) {
            arrayList.add(cluster.getModel().getMean().copy());
        }
        this.initialMeans = arrayList;
    }

    public void setInitialMeans(double[][] dArray) {
        ArrayList<? extends NumberVector> arrayList = new ArrayList<NumberVector>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Vector(dArray[i]));
        }
        this.initialMeans = arrayList;
    }

    @Override
    public <T extends NumberVector, O extends NumberVector> List<O> chooseInitialMeans(Database database, Relation<T> relation, int n, NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction, NumberVector.Factory<O> factory) {
        if (n != this.initialMeans.size()) {
            throw new AbortException("Predefined initial means contained " + this.initialMeans.size() + " means, algorithm requested " + n + " means instead.");
        }
        ArrayList<O> arrayList = new ArrayList<O>(n);
        for (NumberVector numberVector : this.initialMeans) {
            arrayList.add(factory.newNumberVector(numberVector));
        }
        return arrayList;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID INITIAL_MEANS = new OptionID("kmeans.means", "Initial means for k-means.");
        protected List<Vector> initialMeans;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleArrayListParameter doubleArrayListParameter = new DoubleArrayListParameter(INITIAL_MEANS);
            if (parameterization.grab(doubleArrayListParameter)) {
                this.initialMeans = new ArrayList<Vector>(((List)doubleArrayListParameter.getValue()).size());
                for (double[] dArray : (List)doubleArrayListParameter.getValue()) {
                    this.initialMeans.add(new Vector(dArray));
                }
            }
        }

        @Override
        protected PredefinedInitialMeans makeInstance() {
            return new PredefinedInitialMeans(this.initialMeans);
        }
    }
}

