/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLogMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="F. R. Hampel", title="The Influence Curve and Its Role in Robust Estimation", booktitle="Journal of the American Statistical Association, June 1974, Vol. 69, No. 346", url="http://www.jstor.org/stable/10.2307/2285666")
public class LogNormalLogMADEstimator
extends AbstractLogMADEstimator<LogNormalDistribution> {
    public static LogNormalLogMADEstimator STATIC = new LogNormalLogMADEstimator();

    private LogNormalLogMADEstimator() {
    }

    @Override
    public LogNormalDistribution estimateFromLogMedianMAD(double d, double d2, double d3) {
        return new LogNormalDistribution(d, Math.max(1.4826022185056018 * d2, Double.MIN_NORMAL), d3);
    }

    @Override
    public Class<? super LogNormalDistribution> getDistributionClass() {
        return LogNormalDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogNormalLogMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

