/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.opticsplot;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;

public class OPTICSCut {
    public static <E extends ClusterOrder> Clustering<Model> makeOPTICSCut(E e, double d) {
        Clustering<Model> clustering = new Clustering<Model>("OPTICS Cut Clustering", "optics-cut");
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        HashSetModifiableDBIDs hashSetModifiableDBIDs2 = DBIDUtil.newHashSet();
        DBIDVar dBIDVar = DBIDUtil.newVar();
        DBIDArrayIter dBIDArrayIter = e.iter();
        while (dBIDArrayIter.valid()) {
            d2 = d3;
            d3 = e.getReachability(dBIDArrayIter);
            if (d3 <= d) {
                if (d2 > d && dBIDVar.isSet()) {
                    hashSetModifiableDBIDs.remove(dBIDVar);
                    hashSetModifiableDBIDs2.add(dBIDVar);
                }
                hashSetModifiableDBIDs2.add(dBIDArrayIter);
            } else {
                if (!hashSetModifiableDBIDs2.isEmpty()) {
                    clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)hashSetModifiableDBIDs2, ClusterModel.CLUSTER));
                    hashSetModifiableDBIDs2 = DBIDUtil.newHashSet();
                }
                hashSetModifiableDBIDs.add(dBIDArrayIter);
            }
            dBIDVar.set(dBIDArrayIter);
            dBIDArrayIter.advance();
        }
        if (!hashSetModifiableDBIDs2.isEmpty()) {
            clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)hashSetModifiableDBIDs2, ClusterModel.CLUSTER));
        }
        clustering.addToplevelCluster(new Cluster<ClusterModel>(hashSetModifiableDBIDs, true, ClusterModel.CLUSTER));
        return clustering;
    }
}

