/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.epl.EplModule;
import org.eclipse.epsilon.epl.NoMatch;
import org.eclipse.epsilon.epl.Pattern;
import org.eclipse.epsilon.epl.PatternMatch;
import org.eclipse.epsilon.epl.PatternMatchModel;
import org.eclipse.epsilon.epl.Role;
import org.eclipse.epsilon.epl.combinations.CombinationGenerator;
import org.eclipse.epsilon.epl.combinations.CombinationGeneratorListener;
import org.eclipse.epsilon.epl.combinations.CompositeCombinationGenerator;
import org.eclipse.epsilon.epl.combinations.CompositeCombinationValidator;
import org.eclipse.epsilon.epl.combinations.DynamicListCombinationGenerator;

public class PatternMatcher {
    protected Frame frame = null;

    public PatternMatchModel match(EplModule module) throws Exception {
        this.frame = null;
        IEolContext context = module.getContext();
        PatternMatchModel model = new PatternMatchModel();
        if (module.getMaximumLevel() > 0) {
            model.setName(module.getPatternMatchModelName());
            context.getModelRepository().addModel(model);
        }
        model.setPatterns(module.getPatterns());
        int level = 0;
        while (level <= module.getMaximumLevel()) {
            for (Pattern pattern : module.getPatterns()) {
                if (pattern.getLevel() != level) continue;
                for (PatternMatch match : this.match(pattern, context)) {
                    model.addMatch(match);
                }
            }
            for (PatternMatch match : model.getMatches()) {
                AST doAst;
                if (match.getPattern().getLevel() != level || (doAst = match.getPattern().getDoAst()) == null) continue;
                context.getFrameStack().enterLocal(FrameType.UNPROTECTED, doAst, new Variable[0]);
                for (String componentName : match.getRoleBindings().keySet()) {
                    context.getFrameStack().put(Variable.createReadOnlyVariable(componentName, match.getRoleBinding(componentName)));
                }
                context.getExecutorFactory().executeAST(doAst, context);
                context.getFrameStack().leaveLocal(doAst);
            }
            ++level;
        }
        return model;
    }

    public List<PatternMatch> match(final Pattern pattern, final IEolContext context) throws Exception {
        ArrayList<PatternMatch> patternMatches = new ArrayList<PatternMatch>();
        context.getFrameStack().enterLocal(FrameType.PROTECTED, pattern.getAst(), new Variable[0]);
        CompositeCombinationGenerator<Object> generator = new CompositeCombinationGenerator<Object>();
        for (Role role : pattern.getRoles()) {
            generator.addCombinationGenerator(this.createCombinationGenerator(role, context));
        }
        generator.setValidator(new CompositeCombinationValidator<Object>(){

            @Override
            public boolean isValid(List<List<Object>> combination) throws Exception {
                for (Object o : combination.get(combination.size() - 1)) {
                    if (!(o instanceof NoMatch)) continue;
                    return true;
                }
                PatternMatcher.this.frame = context.getFrameStack().enterLocal(FrameType.PROTECTED, pattern.getAst(), new Variable[0]);
                boolean result = true;
                int i = 0;
                Role role = null;
                for (List<Object> values : combination) {
                    role = pattern.getRoles().get(i);
                    for (Variable variable : PatternMatcher.this.getVariables(values, role)) {
                        PatternMatcher.this.frame.put(variable);
                    }
                    ++i;
                }
                if (!role.isNegative() && role.getGuard() != null && role.isActive(context) && role.getCardinality().isOne()) {
                    Return ret = null;
                    ret = (Return)context.getExecutorFactory().executeBlockOrExpressionAst(role.getGuard().getAst().getFirstChild(), context);
                    if (ret.getValue() instanceof Boolean) {
                        result = (Boolean)ret.getValue();
                    }
                }
                context.getFrameStack().leaveLocal(pattern.getAst());
                return result;
            }
        });
        while (generator.hasMore()) {
            List<List<Object>> candidate = generator.getNext();
            boolean matches = true;
            this.frame = context.getFrameStack().enterLocal(FrameType.PROTECTED, pattern.getAst(), new Variable[0]);
            if (pattern.getMatchAst() != null || pattern.getNoMatchAst() != null || pattern.getOnMatchAst() != null) {
                int i = 0;
                for (Role role : pattern.getRoles()) {
                    for (Variable variable : this.getVariables(candidate.get(i), role)) {
                        this.frame.put(variable);
                    }
                    ++i;
                }
            }
            if (pattern.getMatchAst() != null) {
                Object result = context.getExecutorFactory().executeAST(pattern.getMatchAst(), context);
                if (result instanceof Return) {
                    result = ((Return)result).getValue();
                }
                if (result instanceof Boolean) {
                    matches = (Boolean)result;
                } else {
                    throw new EolIllegalReturnException("Boolean", result, pattern.getMatchAst(), context);
                }
            }
            if (matches) {
                context.getExecutorFactory().executeAST(pattern.getOnMatchAst(), context);
                patternMatches.add(this.createPatternMatch(pattern, candidate));
            } else {
                context.getExecutorFactory().executeAST(pattern.getNoMatchAst(), context);
            }
            context.getFrameStack().leaveLocal(pattern.getAst());
        }
        context.getFrameStack().leaveLocal(pattern.getAst());
        return patternMatches;
    }

    protected List<Variable> getVariables(List<Object> combination, Role role) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        int i = 0;
        for (String name : role.getNames()) {
            variables.add(Variable.createReadOnlyVariable(name, combination.get(i)));
            ++i;
        }
        return variables;
    }

    protected CombinationGenerator<Object> createCombinationGenerator(final Role role, final IEolContext context) throws EolRuntimeException {
        DynamicListCombinationGenerator<Object> combinationGenerator = null;
        combinationGenerator = new DynamicListCombinationGenerator<Object>(role.getInstances(context), role.getNames().size()){

            @Override
            public Boolean checkOptional() {
                try {
                    return role.isOptional(context);
                }
                catch (EolRuntimeException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        combinationGenerator.addListener(new CombinationGeneratorListener<Object>(){

            @Override
            public void generated(List<Object> next) {
                if (next == null) {
                    for (String name : role.getNames()) {
                        context.getFrameStack().put(Variable.createReadOnlyVariable(name, NoMatch.INSTANCE));
                    }
                } else {
                    for (Variable variable : PatternMatcher.this.getVariables(next, role)) {
                        context.getFrameStack().put(variable);
                    }
                }
            }

            @Override
            public void reset() {
                for (String variableName : role.getNames()) {
                    context.getFrameStack().remove(variableName);
                }
            }
        });
        return combinationGenerator;
    }

    protected PatternMatch createPatternMatch(Pattern pattern, List<List<Object>> combination) {
        PatternMatch patternMatch = new PatternMatch(pattern);
        int i = 0;
        for (Role role : pattern.getRoles()) {
            for (Variable variable : this.getVariables(combination.get(i), role)) {
                patternMatch.getRoleBindings().put(variable.getName(), variable.getValue());
            }
            ++i;
        }
        return patternMatch;
    }
}

