/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.emc.wrappers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotAnEnumerationValueException;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.models.IReflectiveModel;
import org.eclipse.epsilon.flock.context.ConservativeCopyContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.emc.wrappers.ModelValue;
import org.eclipse.epsilon.flock.emc.wrappers.ModelValueWrapper;
import org.eclipse.epsilon.flock.execution.exceptions.ConservativeCopyException;

public class Model {
    private final IReflectiveModel underlyingModel;
    private final PrettyPrinterManager printer;
    private final ModelValueWrapper wrapper;

    public Model(IReflectiveModel underlyingModel, PrettyPrinterManager printer) {
        this.underlyingModel = underlyingModel;
        this.printer = printer;
        this.wrapper = new ModelValueWrapper(this);
    }

    Model(IReflectiveModel underlyingModel, ModelValueWrapper wrapper) {
        this.underlyingModel = underlyingModel;
        this.printer = new PrettyPrinterManager();
        this.wrapper = wrapper;
    }

    Model(IReflectiveModel underlyingModel) {
        this(underlyingModel, new PrettyPrinterManager());
    }

    public ModelElement createInstance(String typeName) throws EolRuntimeException {
        return this.wrapModelElement(this.underlyingModel.createInstance(typeName));
    }

    public boolean hasType(String typeName) {
        return this.underlyingModel.hasType(typeName);
    }

    public boolean isInstantiable(String typeName) {
        return this.underlyingModel.isInstantiable(typeName);
    }

    public boolean hasProperty(String type, String property) throws EolRuntimeException {
        return this.underlyingModel.hasProperty(type, property);
    }

    public boolean hasPackage(String originalPackage) {
        return this.underlyingModel.hasPackage(originalPackage);
    }

    public Iterable<ModelElement> directContents() {
        LinkedList<ModelElement> modelElements = new LinkedList<ModelElement>();
        for (Object unwrappedModelElement : this.underlyingModel.allContents()) {
            if (!this.underlyingModel.owns(unwrappedModelElement)) continue;
            modelElements.add(this.wrapModelElement(unwrappedModelElement));
        }
        return modelElements;
    }

    public boolean owns(ModelElement element) {
        return this.owns(element.unwrap());
    }

    public boolean owns(Object unwrappedElement) {
        return this.underlyingModel.owns(unwrappedElement);
    }

    public ModelValue<?> wrap(Object value) {
        return this.wrapper.wrapValue(value);
    }

    ModelElement wrapModelElement(Object object) {
        return this.wrapper.wrapModelElement(object);
    }

    boolean isEnumeration(Object object) {
        return this.underlyingModel.isEnumerationValue(object);
    }

    boolean isModelElement(Object object) {
        return this.underlyingModel.isModelElement(object);
    }

    String getTypeNameOf(Object underlyingModelElement) {
        return this.underlyingModel.getFullyQualifiedTypeNameOf(underlyingModelElement);
    }

    String getUnqualifiedTypeNameOf(Object underlyingModelElement) {
        return this.underlyingModel.getTypeNameOf(underlyingModelElement);
    }

    List<String> getPackageNamesOf(Object underlyingModelElement) {
        List<String> parts = Arrays.asList(this.getTypeNameOf(underlyingModelElement).split("::"));
        if (parts.size() > 1) {
            return new LinkedList<String>(parts.subList(0, parts.size() - 1));
        }
        return Collections.emptyList();
    }

    public Object getContainerOf(Object underlyingModelObject) {
        return this.underlyingModel.getContainerOf(underlyingModelObject);
    }

    public boolean isTypeOf(Object underlyingModelElement, String type) {
        try {
            return this.underlyingModel.isOfType(underlyingModelElement, type);
        }
        catch (EolModelElementTypeNotFoundException e) {
            return false;
        }
    }

    boolean isKindOf(Object underlyingModelElement, String type) {
        try {
            return this.underlyingModel.isOfKind(underlyingModelElement, type);
        }
        catch (EolModelElementTypeNotFoundException e) {
            return false;
        }
    }

    boolean knowsAboutProperty(Object underlyingModelElement, String property) {
        return this.underlyingModel.knowsAboutProperty(underlyingModelElement, property);
    }

    Collection<String> getPropertiesOf(String type) throws EolModelElementTypeNotFoundException {
        return this.underlyingModel.getPropertiesOf(type);
    }

    ModelValue<?> getValueOfProperty(Object underlyingModelElement, String property) throws EolRuntimeException {
        return this.wrapper.wrapValue(this.underlyingModel.getPropertyGetter().invoke(underlyingModelElement, property));
    }

    void setValueOfProperty(Object underlyingModelElement, String property, ModelValue<?> value) throws EolRuntimeException {
        IReflectivePropertySetter setter = this.underlyingModel.getPropertySetter();
        setter.setObject(underlyingModelElement);
        setter.setProperty(property);
        setter.invoke(setter.coerce(value.unwrap()));
    }

    boolean conforms(Object underlyingModelElement, String property, ModelValue<?> value) throws EolRuntimeException {
        IReflectivePropertySetter setter = this.underlyingModel.getPropertySetter();
        setter.setObject(underlyingModelElement);
        setter.setProperty(property);
        return setter.conforms(value.unwrap());
    }

    String getStringRepresentationOf(Object underlyingModelObject) {
        return this.printer.print(underlyingModelObject);
    }

    Object getEquivalentEnumerationValue(Object literal) throws EolEnumerationValueNotFoundException, EolNotAnEnumerationValueException {
        String enumeration = this.underlyingModel.getEnumerationTypeOf(literal);
        String label = this.underlyingModel.getEnumerationLabelOf(literal);
        return this.underlyingModel.getEnumerationValue(enumeration, label);
    }

    public Object getUnwrappedEquivalent(Object unwrappedModelElement, Model otherModel, ConservativeCopyContext context) throws ConservativeCopyException {
        return this.wrap(unwrappedModelElement).getUnwrappedEquivalentIn(otherModel, context);
    }

    public boolean preventLoadingOfExternalModelElements() {
        return this.underlyingModel.preventLoadingOfExternalModelElements();
    }

    public String getIdentity(Object underlyingModelObject) {
        return this.underlyingModel.getElementId(underlyingModelObject);
    }

    public void setIdentity(Object underlyingModelObject, String newIdentity) {
        this.underlyingModel.setElementId(underlyingModelObject, newIdentity);
    }
}

