/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.common;

import java.util.Collection;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.execution.GuardedConstructContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.checker.ClassifierTypedConstructChecker;
import org.eclipse.epsilon.flock.model.domain.common.GuardedConstruct;

public abstract class ClassifierTypedConstruct
extends GuardedConstruct {
    private final String originalType;

    public ClassifierTypedConstruct(AST ast, Collection<String> annotations, AST guard, String originalType) {
        super(ast, annotations, guard);
        if (originalType == null) {
            throw new IllegalArgumentException("originalType cannot be null");
        }
        this.originalType = originalType;
    }

    public String getOriginalType() {
        return this.originalType;
    }

    protected boolean isStrict() {
        return this.isAnnotatedWith("strict");
    }

    @Override
    public boolean appliesIn(GuardedConstructContext context) throws FlockRuntimeException {
        return this.typedFor(context) && super.appliesIn(context);
    }

    protected boolean typedFor(GuardedConstructContext context) {
        return context.originalConformsTo(this.originalType, this.isStrict());
    }

    public void check(MigrationStrategyCheckingContext context) {
        new ClassifierTypedConstructChecker(this.originalType, context).check();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ClassifierTypedConstruct)) {
            return false;
        }
        ClassifierTypedConstruct other = (ClassifierTypedConstruct)object;
        return super.equals(other) && this.originalType.equals(other.originalType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.originalType.hashCode();
    }
}

