/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.eclipse.xsd.impl.XSDTermImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDModelGroupImpl
extends XSDTermImpl
implements XSDModelGroup {
    protected static final XSDCompositor COMPOSITOR_EDEFAULT = XSDCompositor.ALL_LITERAL;
    protected static final int COMPOSITOR_EFLAG_OFFSET = 8;
    protected static final int COMPOSITOR_EFLAG_DEFAULT = COMPOSITOR_EDEFAULT.ordinal() << 8;
    private static final XSDCompositor[] COMPOSITOR_EFLAG_VALUES = XSDCompositor.values();
    protected static final int COMPOSITOR_EFLAG = 768;
    protected XSDAnnotation annotation;
    protected EList<XSDParticle> contents;
    protected EList<XSDParticle> particles;

    public static XSDModelGroup createModelGroup(Node node) {
        switch (XSDConstants.nodeType(node)) {
            case 0: {
                XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
                xsdModelGroup.setCompositor(XSDCompositor.ALL_LITERAL);
                xsdModelGroup.setElement((Element)node);
                return xsdModelGroup;
            }
            case 7: {
                XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
                xsdModelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
                xsdModelGroup.setElement((Element)node);
                return xsdModelGroup;
            }
            case 35: {
                XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
                xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                xsdModelGroup.setElement((Element)node);
                return xsdModelGroup;
            }
        }
        return null;
    }

    protected XSDModelGroupImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_MODEL_GROUP;
    }

    @Override
    public XSDCompositor getCompositor() {
        return COMPOSITOR_EFLAG_VALUES[(this.eFlags & 0x300) >>> 8];
    }

    @Override
    public void setCompositor(XSDCompositor newCompositor) {
        XSDCompositor oldCompositor = COMPOSITOR_EFLAG_VALUES[(this.eFlags & 0x300) >>> 8];
        if (newCompositor == null) {
            newCompositor = COMPOSITOR_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFFCFF | newCompositor.ordinal() << 8;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCompositor, (Object)newCompositor));
        }
    }

    @Override
    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)((Object)this.annotation)).eInverseRemove(this, -7, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)((Object)newAnnotation)).eInverseAdd(this, -7, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    @Override
    public EList<XSDParticle> getContents() {
        if (this.contents == null) {
            this.contents = new EObjectContainmentEList<XSDParticle>(XSDParticle.class, this, 7);
        }
        return this.contents;
    }

    @Override
    public EList<XSDParticle> getParticles() {
        if (this.particles == null) {
            this.particles = new EObjectEList<XSDParticle>(XSDParticle.class, this, 8);
        }
        return this.particles;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return this.basicSetAnnotation(null, msgs);
            }
            case 7: {
                return ((InternalEList)this.getContents()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getCompositor();
            }
            case 6: {
                return this.getAnnotation();
            }
            case 7: {
                return this.getContents();
            }
            case 8: {
                return this.getParticles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setCompositor((XSDCompositor)newValue);
                return;
            }
            case 6: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 7: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getParticles().clear();
                this.getParticles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setCompositor(COMPOSITOR_EDEFAULT);
                return;
            }
            case 6: {
                this.setAnnotation(null);
                return;
            }
            case 7: {
                this.getContents().clear();
                return;
            }
            case 8: {
                this.getParticles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return (this.eFlags & 0x300) != COMPOSITOR_EFLAG_DEFAULT;
            }
            case 6: {
                return this.annotation != null;
            }
            case 7: {
                return this.contents != null && !this.contents.isEmpty();
            }
            case 8: {
                return this.particles != null && !this.particles.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (compositor: ");
        result.append(COMPOSITOR_EFLAG_VALUES[(this.eFlags & 0x300) >>> 8]);
        result.append(')');
        return result.toString();
    }

    @Override
    public Element createElement() {
        XSDCompositor theCompositor = this.getCompositor();
        Element newElement = this.createElement(XSDCompositor.ALL_LITERAL == theCompositor ? 0 : (XSDCompositor.CHOICE_LITERAL == theCompositor ? 7 : 35));
        this.setElement(newElement);
        for (XSDParticle xsdParticle : this.getContents()) {
            Element newParticleElement = ((XSDConcreteComponentImpl)((Object)xsdParticle)).createElement();
            newElement.appendChild(newParticleElement);
        }
        return newElement;
    }

    @Override
    protected void patch() {
        super.patch();
        ArrayList<XSDParticle> newParticles = new ArrayList<XSDParticle>(this.getContents());
        ArrayList<XSDParticle> remainingParticles = new ArrayList<XSDParticle>(this.getParticles());
        ListIterator particles = newParticles.listIterator();
        while (particles.hasNext()) {
            XSDParticle xsdParticle = (XSDParticle)particles.next();
            if (xsdParticle.getMaxOccurs() == 0) {
                particles.remove();
                remainingParticles.add(xsdParticle);
                continue;
            }
            remainingParticles.remove(xsdParticle);
        }
        if (!remainingParticles.isEmpty()) {
            this.getParticles().removeAll(remainingParticles);
        }
        XSDModelGroupImpl.setListContentAndOrder(this.getParticles(), newParticles);
    }

    @Override
    public void validate() {
        super.validate();
        boolean hasBounds = !(this.getContainer() instanceof XSDModelGroupDefinition);
        String anchor = null;
        String contentType = null;
        switch (this.getCompositor().getValue()) {
            case 0: {
                anchor = "element-all";
                contentType = "all";
                for (XSDParticle xsdParticle : this.getContents()) {
                    switch (xsdParticle.getMaxOccurs()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "cos-all-limited.2");
                        }
                    }
                }
                break;
            }
            case 2: {
                anchor = "element-sequence";
                contentType = "explicitGroup";
                break;
            }
            case 1: {
                anchor = "element-choice";
                contentType = "explicitGroup";
            }
        }
        Element theElement = this.getElement();
        if (theElement != null) {
            String[] stringArray;
            if (hasBounds) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "id";
                stringArray2[1] = "maxOccurs";
                stringArray = stringArray2;
                stringArray2[2] = "minOccurs";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "id";
            }
            String[] attributes = stringArray;
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", anchor, theElement, attributes);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "id", false);
            if (hasBounds) {
                this.checkAttributeTypeConstraint(contentType, "maxOccurs", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "maxOccurs", false);
                this.checkAttributeTypeConstraint(contentType, "minOccurs", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "minOccurs", false);
            }
            this.checkComplexContent(contentType, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement);
        }
    }

    public void validateRoot() {
        XSDParticleImpl.XSDNFA dfa;
        Collection<XSDDiagnostic> diagnostics;
        XSDParticle xsdParticle;
        XSDConcreteComponent diagnosticTarget = this;
        if (this.getContainer() instanceof XSDParticle) {
            xsdParticle = (XSDParticle)this.getContainer();
            if (xsdParticle.eContainmentFeature() == XSDPackage.Literals.XSD_COMPLEX_TYPE_DEFINITION__SYNTHETIC_PARTICLE) {
                diagnosticTarget = xsdParticle.getContainer();
            }
        } else {
            xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
            xsdParticle.setTerm(this);
        }
        if (!(diagnostics = (dfa = (XSDParticleImpl.XSDNFA)xsdParticle.getDFA()).getDiagnostics()).isEmpty()) {
            for (XSDDiagnostic xsdDiagnostic : diagnostics) {
                xsdDiagnostic.setPrimaryComponent(diagnosticTarget);
                xsdDiagnostic.setNode(diagnosticTarget.getElement());
            }
            this.getDiagnostics().addAll(diagnostics);
        }
    }

    @Override
    protected boolean isUpdatingDOM() {
        return super.isUpdatingDOM() || this.getContainer() instanceof XSDConcreteComponentImpl && ((XSDConcreteComponentImpl)this.getContainer()).isUpdatingDOM();
    }

    @Override
    protected void handleUnreconciledElement(Element child, List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        XSDParticle xsdParticle = XSDParticleImpl.createParticle(child);
        if (xsdParticle != null) {
            newContents.add(xsdParticle);
        } else {
            XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
            if (xsdAnnotation != null && newContents.isEmpty()) {
                newContents.add(xsdAnnotation);
            }
        }
    }

    @Override
    protected void handleReconciliation(List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        this.handleAnnotationReconciliation(XSDPackage.Literals.XSD_MODEL_GROUP__ANNOTATION, newContents, remainingContents);
        if (!remainingContents.isEmpty()) {
            this.getContents().removeAll(remainingContents);
        }
        if (!newContents.isEmpty()) {
            List<XSDConcreteComponent> list = newContents;
            XSDModelGroupImpl.setListContentAndOrder(this.getContents(), list);
        }
    }

    @Override
    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        Element theElement = this.getElement();
        if (!(eAttribute != null && eAttribute != XSDPackage.Literals.XSD_MODEL_GROUP__COMPOSITOR || theElement == null || eAttribute == null || this.isReconciling)) {
            XSDCompositor theCompositor = this.getCompositor();
            Element newElement = this.createElement(XSDCompositor.ALL_LITERAL == theCompositor ? 0 : (XSDCompositor.CHOICE_LITERAL == theCompositor ? 7 : 35));
            this.forceReplace(newElement, theElement);
            this.setElement(newElement);
            XSDConcreteComponentImpl container = (XSDConcreteComponentImpl)this.getContainer();
            if (container instanceof XSDParticle) {
                ((XSDParticle)((Object)container)).setElement(newElement);
                container.changeAttribute(null);
            }
        }
    }

    @Override
    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_MODEL_GROUP__CONTENTS) {
            this.traverseToRootForPatching();
        }
    }

    @Override
    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_MODEL_GROUP__CONTENTS) {
            this.traverseToRootForPatching();
        }
    }

    @Override
    public void moveContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.moveContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_MODEL_GROUP__CONTENTS) {
            this.traverseToRootForPatching();
        }
    }

    @Override
    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDModelGroupImpl clonedModelGroup = (XSDModelGroupImpl)this.getXSDFactory().createXSDModelGroup();
        clonedModelGroup.isReconciling = true;
        clonedModelGroup.setCompositor(this.getCompositor());
        if (deep) {
            if (this.getAnnotation() != null) {
                clonedModelGroup.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
            }
            if (!this.getContents().isEmpty()) {
                clonedModelGroup.getContents().addAll(XSDModelGroupImpl.cloneConcreteComponents(this.getContents(), true, shareDOM));
            }
        }
        if (shareDOM && this.getElement() != null) {
            clonedModelGroup.setElement(this.getElement());
        }
        clonedModelGroup.isReconciling = shareDOM;
        return clonedModelGroup;
    }
}

