/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.output;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.exceptions.EglStoppedException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.merge.partition.CommentBlockPartitioner;
import org.eclipse.epsilon.egl.output.ColumnCounter;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.output.LineCounter;
import org.eclipse.epsilon.egl.status.Warning;
import org.eclipse.epsilon.egl.util.FileUtil;

public class OutputBuffer
implements IOutputBuffer {
    private final StringBuilder buffer = new StringBuilder();
    private final IEglContext context;
    private final LineCounter lineCounter = new LineCounter(FileUtil.NEWLINE);
    private final ColumnCounter columnCounter = new ColumnCounter(FileUtil.NEWLINE);
    private final List<CommentBlockPartitioner> customPartitioners = new LinkedList<CommentBlockPartitioner>();
    private boolean contentTypeSet = false;
    private String lastLine = null;

    public OutputBuffer(IEglContext context) {
        this(context, null);
    }

    public OutputBuffer() {
        this(null, null);
    }

    OutputBuffer(IEglContext context, String contents) {
        this.context = context;
        if (contents != null) {
            this.buffer.append(contents);
        }
    }

    @Override
    public void chop(int chars) {
        int limit = Math.min(chars, this.buffer.length());
        int i = 0;
        while (i < limit) {
            this.buffer.deleteCharAt(this.buffer.length() - 1);
            ++i;
        }
    }

    @Override
    public void print(Object o) {
        this.buffer.append(o == null ? "null" : o.toString());
    }

    @Override
    public void printdyn(Object o) {
        String indentation = this.calculateIndentationToMatch(this.getLastLineInBuffer());
        String[] lines = StringUtil.toString(o).split(FileUtil.NEWLINE);
        int i = 0;
        while (i < lines.length) {
            if (i == 0) {
                this.buffer.append(lines[i]);
            } else {
                this.buffer.append(String.valueOf(FileUtil.NEWLINE) + indentation + lines[i]);
            }
            ++i;
        }
    }

    @Override
    public void prinx(Object o) {
        this.print(o);
    }

    private String getLastLineInBuffer() {
        int indexOfLastLine = this.buffer.lastIndexOf("\n");
        if (indexOfLastLine == -1) {
            return this.buffer.substring(0, this.buffer.length());
        }
        return this.buffer.substring(indexOfLastLine + 1, this.buffer.length());
    }

    private String calculateIndentationToMatch(String previousLine) {
        StringBuilder builder = new StringBuilder();
        char[] cArray = previousLine.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isWhitespace(c)) {
                builder.append(c);
            } else {
                builder.append(' ');
            }
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public String getSpaces(int howMany) {
        String str = "";
        int i = 0;
        while (i < howMany) {
            str = String.valueOf(str) + " ";
            ++i;
        }
        return str;
    }

    @Override
    public void println() {
        this.buffer.append(FileUtil.NEWLINE);
    }

    @Override
    public void println(Object o) {
        this.print(o);
        this.println();
    }

    @Override
    public String preserve(String id, boolean enabled, String contents) throws EglRuntimeException {
        return String.valueOf(this.startPreserve(id, enabled)) + FileUtil.NEWLINE + contents + FileUtil.NEWLINE + this.stopPreserve();
    }

    @Override
    public String preserve(String startComment, String endComment, String id, boolean enabled, String contents) throws EglRuntimeException {
        return String.valueOf(this.startPreserve(startComment, endComment, id, enabled)) + FileUtil.NEWLINE + contents + FileUtil.NEWLINE + this.stopPreserve();
    }

    @Override
    public void setContentType(String name) throws EglRuntimeException {
        if (this.contentTypeSet) {
            this.context.addStatusMessage(new Warning("Cannot set content type to '" + name + "' - content type already specified."));
        } else {
            if (!this.context.usePartitionerFor(name)) {
                throw new EglRuntimeException("'" + name + "' is not a recognised content type.", this.context.getModule().getAst());
            }
            for (CommentBlockPartitioner customPartitioner : this.customPartitioners) {
                this.context.getPartitioner().addPartitioner(customPartitioner);
            }
            this.contentTypeSet = true;
        }
    }

    @Override
    public String startPreserve(String id, boolean enabled) throws EglRuntimeException {
        if (this.lastLine != null) {
            throw new EglRuntimeException("Preservation of the current region must be stopped before preservation of another region may begin.", this.context.getModule().getAst());
        }
        if (this.context.getPartitioner().getDefaultPartitioner() == null) {
            throw new EglRuntimeException("A content type must be specified before using startPreserve(id, enabled).", this.context.getModule().getAst());
        }
        this.lastLine = this.context.getPartitioner().getDefaultPartitioner().getLastLine(id);
        return this.context.getPartitioner().getDefaultPartitioner().getFirstLine(id, enabled);
    }

    @Override
    public String startPreserve(String startComment, String endComment, String id, boolean enabled) throws EglRuntimeException {
        if (this.lastLine != null) {
            throw new EglRuntimeException("Preservation of the current region must be stopped before preservation of another region may begin.", this.context.getModule().getAst());
        }
        CommentBlockPartitioner customPartitioner = new CommentBlockPartitioner(startComment, endComment);
        this.lastLine = customPartitioner.getLastLine(id);
        this.context.getPartitioner().addPartitioner(customPartitioner);
        this.customPartitioners.add(customPartitioner);
        return customPartitioner.getFirstLine(id, enabled);
    }

    @Override
    public String stopPreserve() throws EglRuntimeException {
        if (this.lastLine == null) {
            throw new EglRuntimeException("There is no current region to stop preserving.", this.context.getModule().getAst());
        }
        String result = this.lastLine;
        this.lastLine = null;
        return result;
    }

    @Override
    public void stop() throws EglStoppedException {
        throw new EglStoppedException(this.context.getModule().getAst());
    }

    @Override
    public int getCurrentLineNumber() {
        return this.lineCounter.getCurrentLineNumberFor(this.buffer.toString());
    }

    @Override
    public int getCurrentColumnNumber() {
        return this.columnCounter.getCurrentColumnNumberFrom(this.buffer.toString());
    }

    @Override
    public int getOffset() {
        return this.buffer.toString().length();
    }

    @Override
    public void formatWith(Formatter formatter) {
        this.replaceContentsWith(formatter.format(this.buffer.toString()));
    }

    private void replaceContentsWith(String newContents) {
        this.buffer.setLength(0);
        this.buffer.append(newContents);
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

