/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;

public class RangeQuerySelectivity<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, Result> {
    private static final Logging LOG = Logging.getLogger(RangeQuerySelectivity.class);
    protected double radius;
    protected double sampling = 1.0;
    protected RandomFactory random = null;

    public RangeQuerySelectivity(DistanceFunction<? super V> distanceFunction, double d, double d2, RandomFactory randomFactory) {
        super(distanceFunction);
        this.radius = d;
        this.sampling = d2;
        this.random = randomFactory;
    }

    public Result run(Database database, Relation<V> relation) {
        DistanceQuery<V> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<V> rangeQuery = database.getRangeQuery(distanceQuery, this.radius);
        MeanVariance meanVariance = new MeanVariance();
        DBIDs dBIDs = DBIDUtil.randomSample(relation.getDBIDs(), this.sampling, this.random);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Performing range queries", dBIDs.size(), LOG) : null;
        Object object = dBIDs.iter();
        while (object.valid()) {
            meanVariance.put(rangeQuery.getRangeForDBID((DBIDRef)object, this.radius).size());
            LOG.incrementProcessed(finiteProgress);
            object.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object = this.getClass().getName();
        LOG.statistics(new DoubleStatistic((String)object + ".mean", meanVariance.getMean()));
        LOG.statistics(new DoubleStatistic((String)object + ".std", meanVariance.getSampleStddev()));
        LOG.statistics(new DoubleStatistic((String)object + ".norm.mean", meanVariance.getMean() / (double)relation.size()));
        LOG.statistics(new DoubleStatistic((String)object + ".norm.std", meanVariance.getSampleStddev() / (double)relation.size()));
        LOG.statistics(new LongStatistic((String)object + ".samplesize", dBIDs.size()));
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID RADIUS_ID = new OptionID("selectivity.radius", "Radius to use for selectivity estimation.");
        public static final OptionID SAMPLING_ID = new OptionID("selectivity.sampling", "Relative amount of object to sample.");
        public static final OptionID SEED_ID = new OptionID("selectivity.sampling-seed", "Random seed for deterministic sampling.");
        protected double radius;
        protected double sampling = 1.0;
        protected RandomFactory random = RandomFactory.DEFAULT;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(RADIUS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.radius = doubleParameter.doubleValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(SAMPLING_ID);
            doubleParameter2.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter2.addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            doubleParameter2.setOptional(true);
            if (parameterization.grab(doubleParameter2)) {
                this.sampling = (Double)doubleParameter2.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RangeQuerySelectivity<V> makeInstance() {
            return new RangeQuerySelectivity(this.distanceFunction, this.radius, this.sampling, this.random);
        }
    }
}

