/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.LeastOverlapInsertionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.Collections;

@Reference(authors="N. Beckmann, H.-P. Kriegel, R. Schneider, B. Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proceedings of the 1990 ACM SIGMOD International Conference on Management of Data, Atlantic City, NJ, May 23-25, 1990", url="http://dx.doi.org/10.1145/93597.98741")
public class ApproximativeLeastOverlapInsertionStrategy
extends LeastOverlapInsertionStrategy {
    private int numCandidates = 32;

    public ApproximativeLeastOverlapInsertionStrategy(int n) {
        this.numCandidates = n;
    }

    @Override
    public <A> int choose(A a, ArrayAdapter<? extends SpatialComparable, A> arrayAdapter, SpatialComparable spatialComparable, int n, int n2) {
        double d;
        int n3;
        int n4 = arrayAdapter.size(a);
        assert (n4 > 0) : "Choose from empty set?";
        if (n4 <= this.numCandidates) {
            return super.choose(a, arrayAdapter, spatialComparable, n, n2);
        }
        TopBoundedHeap topBoundedHeap = new TopBoundedHeap(this.numCandidates, Collections.reverseOrder());
        for (n3 = 0; n3 < n4; ++n3) {
            SpatialComparable spatialComparable2 = arrayAdapter.get(a, n3);
            ModifiableHyperBoundingBox modifiableHyperBoundingBox = SpatialUtil.union(spatialComparable2, spatialComparable);
            d = SpatialUtil.volume(modifiableHyperBoundingBox) - SpatialUtil.volume(spatialComparable2);
            topBoundedHeap.add(new DoubleIntPair(d, n3));
        }
        n3 = -1;
        double d2 = Double.POSITIVE_INFINITY;
        d = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        while (!topBoundedHeap.isEmpty()) {
            double d4;
            DoubleIntPair doubleIntPair = (DoubleIntPair)topBoundedHeap.poll();
            double d5 = doubleIntPair.first;
            SpatialComparable spatialComparable3 = arrayAdapter.get(a, doubleIntPair.second);
            ModifiableHyperBoundingBox modifiableHyperBoundingBox = SpatialUtil.union(spatialComparable3, spatialComparable);
            double d6 = 0.0;
            double d7 = 0.0;
            for (int i = 0; i < n4; ++i) {
                if (doubleIntPair.second == i) continue;
                SpatialComparable spatialComparable4 = arrayAdapter.get(a, i);
                d6 += SpatialUtil.relativeOverlap(spatialComparable3, spatialComparable4);
                d7 += SpatialUtil.relativeOverlap(modifiableHyperBoundingBox, spatialComparable4);
            }
            double d8 = d7 - d6;
            if (d8 < d2) {
                d4 = SpatialUtil.volume(spatialComparable3);
                d2 = d8;
                d = d5;
                d3 = d4;
                n3 = doubleIntPair.second;
                continue;
            }
            if (d8 != d2) continue;
            d4 = SpatialUtil.volume(spatialComparable3);
            if (!(d5 < d) && (d5 != d || !(d4 < d3))) continue;
            d2 = d8;
            d = d5;
            d3 = d4;
            n3 = doubleIntPair.second;
        }
        assert (n3 > -1) : "No split found? Volume outside of double precision?";
        return n3;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static OptionID INSERTION_CANDIDATES_ID = new OptionID("rtree.insertion-candidates", "defines how many children are tested for finding the child generating the least overlap when inserting an object.");
        int numCandidates = 32;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(INSERTION_CANDIDATES_ID, this.numCandidates);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.numCandidates = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected ApproximativeLeastOverlapInsertionStrategy makeInstance() {
            return new ApproximativeLeastOverlapInsertionStrategy(this.numCandidates);
        }
    }
}

