/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.WaldDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMeanVarianceEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class WaldMOMEstimator
extends AbstractMeanVarianceEstimator<WaldDistribution> {
    public static final WaldMOMEstimator STATIC = new WaldMOMEstimator();

    @Override
    public WaldDistribution estimateFromMeanVariance(MeanVariance meanVariance) {
        double d = meanVariance.getMean();
        return new WaldDistribution(d, d * d * d / meanVariance.getSampleVariance());
    }

    @Override
    public Class<? super WaldDistribution> getDistributionClass() {
        return WaldDistribution.class;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WaldMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

