/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.AttributeExpression;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class AddExpression
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 402130384261736245L;
    private String m_infixExpression = "a1^2";
    private String m_attributeName = "expression";
    private boolean m_Debug = false;
    private AttributeExpression m_attributeExpression = null;

    public String globalInfo() {
        return "An instance filter that creates a new attribute by applying a mathematical expression to existing attributes. The expression can contain attribute references and numeric constants. Supported operators are :\n+, -, *, /, ^, log, abs, cos, exp, sqrt, floor, ceil, rint, tan, sin, (, )\nAttributes are specified by prefixing with 'a', eg. a7 is attribute number 7 (starting from 1).\nExample expression : a1^2*a5/log(a7*4.0).";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSpecify the expression to apply. Eg a1^2*a5/log(a7*4.0).\n\tSupported opperators: ,+, -, *, /, ^, log, abs, cos, \n\texp, sqrt, floor, ceil, rint, tan, sin, (, )\n\t(default: a1^2)", "E", 1, "-E <expression>"));
        newVector.addElement(new Option("\tSpecify the name for the new attribute. (default is the expression provided with -E)", "N", 1, "-N <name>"));
        newVector.addElement(new Option("\tDebug. Names attribute with the postfix parse of the expression.", "D", 0, "-D"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String expString = Utils.getOption('E', options);
        if (expString.length() != 0) {
            this.setExpression(expString);
        } else {
            this.setExpression("a1^2");
        }
        String name = Utils.getOption('N', options);
        if (name.length() != 0) {
            this.setName(name);
        }
        this.setDebug(Utils.getFlag('D', options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-E");
        options.add(this.getExpression());
        options.add("-N");
        options.add(this.getName());
        if (this.getDebug()) {
            options.add("-D");
        }
        return options.toArray(new String[0]);
    }

    public String nameTipText() {
        return "Set the name of the new attribute.";
    }

    public void setName(String name) {
        this.m_attributeName = name;
    }

    public String getName() {
        return this.m_attributeName;
    }

    public String debugTipText() {
        return "Set debug mode. If true then the new attribute will be named with the postfix parse of the supplied expression.";
    }

    public void setDebug(boolean d) {
        this.m_Debug = d;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String expressionTipText() {
        return "Set the math expression to apply. Eg. a1^2*a5/log(a7*4.0)";
    }

    public void setExpression(String expr) {
        this.m_infixExpression = expr;
    }

    public String getExpression() {
        return this.m_infixExpression;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        this.m_attributeExpression = new AttributeExpression();
        this.m_attributeExpression.convertInfixToPostfix(new String(this.m_infixExpression));
        super.setInputFormat(instanceInfo);
        Instances outputFormat = new Instances(instanceInfo, 0);
        Attribute newAttribute = this.m_Debug ? new Attribute(this.m_attributeExpression.getPostFixExpression()) : (this.m_attributeName.compareTo("expression") != 0 ? new Attribute(this.m_attributeName) : new Attribute(this.m_infixExpression));
        outputFormat.insertAttributeAt(newAttribute, instanceInfo.numAttributes());
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] vals = new double[instance.numAttributes() + 1];
        int i = 0;
        while (i < instance.numAttributes()) {
            vals[i] = instance.isMissing(i) ? Utils.missingValue() : instance.value(i);
            ++i;
        }
        this.m_attributeExpression.evaluateExpression(vals);
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(this.getOutputFormat());
        this.copyValues(inst, false, instance.dataset(), this.getOutputFormat());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
        return true;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] args) {
        AddExpression.runFilter(new AddExpression(), args);
    }
}

