/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.smpso;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractParticleSwarmOptimization;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SMPSO
extends AbstractParticleSwarmOptimization<DoubleSolution, List<DoubleSolution>> {
    private DoubleProblem problem;
    private double c1Max;
    private double c1Min;
    private double c2Max;
    private double c2Min;
    private double r1Max;
    private double r1Min;
    private double r2Max;
    private double r2Min;
    private double weightMax;
    private double weightMin;
    private double changeVelocity1;
    private double changeVelocity2;
    private int swarmSize;
    private int maxIterations;
    private int iterations;
    private DoubleSolution[] best;
    private JMetalRandom randomGenerator;
    private Archive<DoubleSolution> leaders;
    private double[][] speed;
    private Comparator<DoubleSolution> dominanceComparator;
    private Comparator<DoubleSolution> crowdingDistanceComparator;
    private MutationOperator<DoubleSolution> mutation;
    private double[] deltaMax;
    private double[] deltaMin;
    private SolutionListEvaluator<DoubleSolution> evaluator;

    public SMPSO(DoubleProblem problem, int swarmSize, Archive<DoubleSolution> leaders, MutationOperator<DoubleSolution> mutationOperator, int maxIterations, double r1Min, double r1Max, double r2Min, double r2Max, double c1Min, double c1Max, double c2Min, double c2Max, double weightMin, double weightMax, double changeVelocity1, double changeVelocity2, SolutionListEvaluator<DoubleSolution> evaluator) {
        this.problem = problem;
        this.swarmSize = swarmSize;
        this.leaders = leaders;
        this.mutation = mutationOperator;
        this.maxIterations = maxIterations;
        this.r1Max = r1Max;
        this.r1Min = r1Min;
        this.r2Max = r2Max;
        this.r2Min = r2Min;
        this.c1Max = c1Max;
        this.c1Min = c1Min;
        this.c2Max = c2Max;
        this.c2Min = c2Min;
        this.weightMax = weightMax;
        this.weightMin = weightMin;
        this.changeVelocity1 = changeVelocity1;
        this.changeVelocity2 = changeVelocity2;
        this.randomGenerator = JMetalRandom.getInstance();
        this.evaluator = evaluator;
        this.dominanceComparator = new DominanceComparator<DoubleSolution>();
        this.crowdingDistanceComparator = new CrowdingDistanceComparator<DoubleSolution>();
        this.best = new DoubleSolution[swarmSize];
        this.speed = new double[swarmSize][problem.getNumberOfVariables()];
        this.deltaMax = new double[problem.getNumberOfVariables()];
        this.deltaMin = new double[problem.getNumberOfVariables()];
        for (int i = 0; i < problem.getNumberOfVariables(); ++i) {
            this.deltaMax[i] = (problem.getUpperBound(i) - problem.getLowerBound(i)) / 2.0;
            this.deltaMin[i] = -this.deltaMax[i];
        }
    }

    @Override
    public void run() {
        List<DoubleSolution> swarm = this.createInitialSwarm();
        swarm = this.evaluateSwarm(swarm);
        this.initializeLeaders(swarm);
        this.initializeParticlesMemory(swarm);
        this.initializeLeaders(swarm);
        this.updateLeadersDensityEstimator();
        this.initProgress();
        while (!this.isStoppingConditionReached()) {
            this.updateVelocity(swarm);
            this.updatePosition(swarm);
            this.perturbation(swarm);
            swarm = this.evaluateSwarm(swarm);
            this.updateLeaders(swarm);
            this.updateParticlesMemory(swarm);
            this.updateLeadersDensityEstimator();
            this.updateProgress();
        }
    }

    protected void updateLeadersDensityEstimator() {
        if (!(this.leaders instanceof CrowdingDistanceArchive)) {
            throw new JMetalException("Invalid setArchive type");
        }
        ((CrowdingDistanceArchive)this.leaders).computeDistance();
    }

    @Override
    protected void initProgress() {
        this.iterations = 1;
    }

    @Override
    protected void updateProgress() {
        ++this.iterations;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.iterations >= this.maxIterations;
    }

    @Override
    protected List<DoubleSolution> createInitialSwarm() {
        ArrayList<DoubleSolution> swarm = new ArrayList<DoubleSolution>(this.swarmSize);
        for (int i = 0; i < this.swarmSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            swarm.add(newSolution);
        }
        return swarm;
    }

    @Override
    protected List<DoubleSolution> evaluateSwarm(List<DoubleSolution> swarm) {
        swarm = this.evaluator.evaluate(swarm, this.problem);
        return swarm;
    }

    @Override
    protected void initializeLeaders(List<DoubleSolution> swarm) {
        for (DoubleSolution solution : swarm) {
            DoubleSolution particle = (DoubleSolution)solution.copy();
            this.leaders.add(particle);
        }
    }

    @Override
    protected void initializeVelocity(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                this.speed[i][j] = 0.0;
            }
        }
    }

    @Override
    protected void initializeParticlesMemory(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle;
            this.best[i] = particle = (DoubleSolution)swarm.get(i).copy();
        }
    }

    @Override
    protected void updateVelocity(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle = (DoubleSolution)swarm.get(i).copy();
            DoubleSolution bestParticle = (DoubleSolution)this.best[i].copy();
            DoubleSolution bestGlobal = this.selectGlobalBest();
            double r1 = this.randomGenerator.nextDouble(this.r1Min, this.r1Max);
            double r2 = this.randomGenerator.nextDouble(this.r2Min, this.r2Max);
            double c1 = this.randomGenerator.nextDouble(this.c1Min, this.c1Max);
            double c2 = this.randomGenerator.nextDouble(this.c2Min, this.c2Max);
            double wmax = this.weightMax;
            double wmin = this.weightMin;
            for (int var = 0; var < particle.getNumberOfVariables(); ++var) {
                this.speed[i][var] = this.velocityConstriction(this.constrictionCoefficient(c1, c2) * (this.inertiaWeight(this.iterations, this.maxIterations, wmax, wmin) * this.speed[i][var] + c1 * r1 * ((Double)bestParticle.getVariableValue(var) - (Double)particle.getVariableValue(var)) + c2 * r2 * ((Double)bestGlobal.getVariableValue(var) - (Double)particle.getVariableValue(var))), this.deltaMax, this.deltaMin, var);
            }
        }
    }

    @Override
    protected void updatePosition(List<DoubleSolution> swarm) {
        for (int i = 0; i < this.swarmSize; ++i) {
            DoubleSolution particle = swarm.get(i);
            for (int j = 0; j < particle.getNumberOfVariables(); ++j) {
                particle.setVariableValue(j, (Double)particle.getVariableValue(j) + this.speed[i][j]);
                if ((Double)particle.getVariableValue(j) < this.problem.getLowerBound(j)) {
                    particle.setVariableValue(j, this.problem.getLowerBound(j));
                    this.speed[i][j] = this.speed[i][j] * this.changeVelocity1;
                }
                if (!((Double)particle.getVariableValue(j) > this.problem.getUpperBound(j))) continue;
                particle.setVariableValue(j, this.problem.getUpperBound(j));
                this.speed[i][j] = this.speed[i][j] * this.changeVelocity2;
            }
        }
    }

    @Override
    protected void perturbation(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            if (i % 6 != 0) continue;
            this.mutation.execute(swarm.get(i));
        }
    }

    @Override
    protected void updateLeaders(List<DoubleSolution> swarm) {
        for (DoubleSolution solution : swarm) {
            DoubleSolution particle = (DoubleSolution)solution.copy();
            this.leaders.add(particle);
        }
    }

    @Override
    protected void updateParticlesMemory(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle;
            int flag = this.dominanceComparator.compare(swarm.get(i), this.best[i]);
            if (flag == 1) continue;
            this.best[i] = particle = (DoubleSolution)swarm.get(i).copy();
        }
    }

    @Override
    public List<DoubleSolution> getResult() {
        return this.leaders.getSolutionList();
    }

    protected DoubleSolution selectGlobalBest() {
        DoubleSolution two;
        int pos1 = this.randomGenerator.nextInt(0, this.leaders.getSolutionList().size() - 1);
        int pos2 = this.randomGenerator.nextInt(0, this.leaders.getSolutionList().size() - 1);
        DoubleSolution one = this.leaders.getSolutionList().get(pos1);
        DoubleSolution bestGlobal = this.crowdingDistanceComparator.compare(one, two = this.leaders.getSolutionList().get(pos2)) < 1 ? (DoubleSolution)one.copy() : (DoubleSolution)two.copy();
        return bestGlobal;
    }

    private double velocityConstriction(double v, double[] deltaMax, double[] deltaMin, int variableIndex) {
        double dmax = deltaMax[variableIndex];
        double dmin = deltaMin[variableIndex];
        double result = v;
        if (v > dmax) {
            result = dmax;
        }
        if (v < dmin) {
            result = dmin;
        }
        return result;
    }

    private double constrictionCoefficient(double c1, double c2) {
        double rho = c1 + c2;
        if (rho <= 4.0) {
            return 1.0;
        }
        return 2.0 / (2.0 - rho - Math.sqrt(Math.pow(rho, 2.0) - 4.0 * rho));
    }

    private double inertiaWeight(int iter, int miter, double wma, double wmin) {
        return wma;
    }
}

