/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.ArrayList;
import java.util.List;

@Title(value="K-Medians")
@Reference(title="Clustering via Concave Minimization", authors="P. S. Bradley, O. L. Mangasarian, W. N. Street", booktitle="Advances in Neural Information Processing Systems", url="https://papers.nips.cc/paper/1260-clustering-via-concave-minimization.pdf")
public class KMediansLloyd<V extends NumberVector>
extends AbstractKMeans<V, MeanModel> {
    private static final Logging LOG = Logging.getLogger(KMediansLloyd.class);
    private static final String KEY = KMediansLloyd.class.getName();

    public KMediansLloyd(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super V> kMeansInitialization) {
        super(numberVectorDistanceFunction, n, n2, kMeansInitialization);
    }

    @Override
    public Clustering<MeanModel> run(Database database, Relation<V> relation) {
        int n;
        if (relation.size() <= 0) {
            return new Clustering<MeanModel>("k-Medians Clustering", "kmedians-clustering");
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, this.k, this.getDistanceFunction(), Vector.FACTORY);
        ArrayList<HashSetModifiableDBIDs> arrayList = new ArrayList<HashSetModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            arrayList.add(DBIDUtil.newHashSet((int)((double)relation.size() * 2.0 / (double)this.k)));
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        double[] dArray = new double[this.k];
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("K-Medians iteration", LOG) : null;
        for (n = 0; this.maxiter <= 0 || n < this.maxiter; ++n) {
            LOG.incrementProcessed(indefiniteProgress);
            boolean bl = this.assignToNearestCluster(relation, list, arrayList, writableIntegerDataStore, dArray);
            if (!bl) break;
            list = this.medians(arrayList, list, relation);
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n));
        }
        Clustering<MeanModel> clustering = new Clustering<MeanModel>("k-Medians Clustering", "kmedians-clustering");
        for (int i = 0; i < arrayList.size(); ++i) {
            MeanModel meanModel = new MeanModel(list.get(i));
            clustering.addToplevelCluster(new Cluster<MeanModel>((DBIDs)arrayList.get(i), meanModel));
        }
        return clustering;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected KMediansLloyd<V> makeInstance() {
            return new KMediansLloyd(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }
}

