/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.strings;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Description(value="Levenshtein distance.")
@Reference(authors="V. I. Levenshtein", title="Binary codes capable of correcting deletions, insertions and reversals.", booktitle="Soviet physics doklady. Vol. 10. 1966.")
public class LevenshteinDistanceFunction
extends AbstractPrimitiveDistanceFunction<String> {
    public static final LevenshteinDistanceFunction STATIC_SENSITIVE = new LevenshteinDistanceFunction();

    @Deprecated
    public LevenshteinDistanceFunction() {
    }

    @Override
    public double distance(String string, String string2) {
        if (string.equals(string2)) {
            return 0.0;
        }
        return LevenshteinDistanceFunction.levenshteinDistance(string, string2);
    }

    public static int levenshteinDistance(String string, String string2) {
        int n;
        if (string.length() < string2.length()) {
            return LevenshteinDistanceFunction.levenshteinDistance(string2, string);
        }
        int n2 = string.length();
        int n3 = string2.length();
        int[] nArray = new int[n3 + 1];
        int[] nArray2 = new int[n3 + 1];
        for (n = 0; n <= n3; ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
            nArray[0] = n + 1;
            for (int i = 0; i < n3; ++i) {
                int n4 = string.charAt(n) == string2.charAt(i) ? 0 : 1;
                nArray[i + 1] = Math.min(nArray2[i + 1] + 1, Math.min(nArray[i] + 1, nArray2[i] + n4));
            }
        }
        n = nArray[string2.length()];
        return n;
    }

    @Override
    public SimpleTypeInformation<? super String> getInputTypeRestriction() {
        return TypeUtil.STRING;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LevenshteinDistanceFunction makeInstance() {
            return STATIC_SENSITIVE;
        }
    }
}

