/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMeanVarianceEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="G. Casella, R. L. Berger", title="Statistical inference. Vol. 70", booktitle="Statistical inference. Vol. 70")
public class GammaMOMEstimator
extends AbstractMeanVarianceEstimator<GammaDistribution> {
    public static final GammaMOMEstimator STATIC = new GammaMOMEstimator();

    private GammaMOMEstimator() {
    }

    @Override
    public GammaDistribution estimateFromMeanVariance(MeanVariance meanVariance) {
        double d = meanVariance.getMean();
        double d2 = meanVariance.getSampleVariance();
        if (d < Double.MIN_NORMAL || d2 < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero mean or variance: " + meanVariance.toString());
        }
        double d3 = d / d2;
        double d4 = d * d3;
        if (!(d4 > 0.0) || !(d3 > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + d4 + " theta=" + d3);
        }
        return new GammaDistribution(d4, d3);
    }

    @Override
    public Class<? super GammaDistribution> getDistributionClass() {
        return GammaDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GammaMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

