/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogLogisticDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Applied Robust Statistics", authors="D. J. Olive", booktitle="Applied Robust Statistics", url="http://lagrange.math.siu.edu/Olive/preprints.htm")
public class LogLogisticMADEstimator
extends AbstractMADEstimator<LogLogisticDistribution> {
    public static final LogLogisticMADEstimator STATIC = new LogLogisticMADEstimator();

    private LogLogisticMADEstimator() {
    }

    @Override
    public LogLogisticDistribution estimateFromMedianMAD(double d, double d2) {
        return new LogLogisticDistribution(1.0 / d, MathUtil.LOG3 / d2);
    }

    @Override
    public Class<? super LogLogisticDistribution> getDistributionClass() {
        return LogLogisticDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogLogisticMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

