/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp;

import java.io.Serializable;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;

public abstract class CommandGene
implements Comparable,
Serializable {
    private static final String CVS_REVISION = "$Revision: 1.40 $";
    static final String PERSISTENT_FIELD_DELIMITER = ":";
    static final String EXTENDED_INFO_DELIMITER = "~";
    public static final double DELTA = 1.0E-7;
    public static final Class BooleanClass = Boolean.class;
    public static final Class IntegerClass = Integer.class;
    public static final Class LongClass = Long.class;
    public static final Class FloatClass = Float.class;
    public static final Class DoubleClass = Double.class;
    public static final Class VoidClass = Void.class;
    public static final Class CharacterClass = Character.class;
    private GPConfiguration m_configuration;
    private boolean m_noValidation;
    private Class m_returnType;
    private int m_arity;
    private int m_arityMin;
    private int m_arityMax;
    private boolean m_integerType;
    private boolean m_floatType;
    private double m_energy;
    private Object m_applicationData;
    private boolean m_compareAppData;
    private int m_subReturnType;
    private int[] m_subChildTypes;
    public int nodeIndex;

    protected void init() {
    }

    public CommandGene() throws Exception {
    }

    public CommandGene(GPConfiguration a_conf, int a_arity, Class a_returnType) throws InvalidConfigurationException {
        if (a_conf == null) {
            throw new InvalidConfigurationException("Configuration must not be null!");
        }
        this.m_configuration = a_conf;
        this.init();
        this.m_arity = a_arity;
        this.m_returnType = a_returnType;
        if (a_returnType == Integer.class || a_returnType == Long.class || a_returnType == IntegerClass || a_returnType == LongClass) {
            this.m_integerType = true;
        } else if (a_returnType == Double.class || a_returnType == Float.class || a_returnType == DoubleClass || a_returnType == FloatClass) {
            this.m_floatType = true;
        }
    }

    public CommandGene(GPConfiguration a_conf, int a_arity, Class a_returnType, int a_subReturnType, int[] a_childSubTypes) throws InvalidConfigurationException {
        this(a_conf, a_arity, a_returnType);
        if (a_childSubTypes != null) {
            boolean specialCase = false;
            if (a_childSubTypes.length == 1 && a_childSubTypes[0] == 0) {
                this.m_subChildTypes = null;
                specialCase = true;
            }
            if (!specialCase) {
                if (a_childSubTypes.length != a_arity) {
                    throw new IllegalArgumentException("Length of child sub types must equal the given arity (or set the former to null)");
                }
                this.m_subChildTypes = a_childSubTypes;
            }
        } else {
            this.m_subChildTypes = null;
        }
        this.m_subReturnType = a_subReturnType;
    }

    public CommandGene(GPConfiguration a_conf, int a_arity, Class a_returnType, int a_subReturnType) throws InvalidConfigurationException {
        this(a_conf, a_arity, a_returnType, a_subReturnType, null);
    }

    public CommandGene(GPConfiguration a_conf, int a_arity, Class a_returnType, int a_subReturnType, int a_childSubType) throws InvalidConfigurationException {
        this(a_conf, a_arity, a_returnType, a_subReturnType, new int[]{a_childSubType});
    }

    public void setAllele(Object a_newValue) {
        throw new UnsupportedOperationException("Method setAllele() not used.");
    }

    public Object getAllele() {
        return null;
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
    }

    public void cleanup() {
    }

    public int size() {
        return this.m_arity;
    }

    public int getArity(IGPProgram a_indvividual) {
        return this.m_arity;
    }

    protected void setArity(int a_arity) {
        this.m_arity = a_arity;
    }

    public void dynamizeArity() {
    }

    protected void setArityMin(int a_arityMin) {
        this.m_arityMin = a_arityMin;
    }

    protected void setArityMax(int a_arityMax) {
        this.m_arityMax = a_arityMax;
    }

    protected int getArityMin() {
        return this.m_arityMin;
    }

    protected int getArityMax() {
        return this.m_arityMax;
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        CommandGene other = (CommandGene)a_other;
        if (this.getClass() != other.getClass()) {
            return -1;
        }
        CompareToBuilder comparator = new CompareToBuilder();
        comparator.append(this.size(), other.size()).append(this.m_subChildTypes, other.m_subChildTypes).append(this.m_subReturnType, other.m_subReturnType);
        if (this.m_compareAppData) {
            comparator.append(this.m_applicationData, other.m_applicationData);
        }
        return comparator.toComparison();
    }

    public boolean equals(Object a_other) {
        if (a_other == null) {
            return false;
        }
        try {
            CommandGene other = (CommandGene)a_other;
            EqualsBuilder equals = new EqualsBuilder();
            equals.append(this.size(), other.size()).append(this.m_subChildTypes, other.m_subChildTypes).append(this.m_subReturnType, other.m_subReturnType).append((Object)this.m_returnType, (Object)other.m_returnType);
            if (this.m_compareAppData) {
                equals.append(this.m_applicationData, other.m_applicationData);
            }
            return equals.isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public abstract String toString();

    public Object execute(ProgramChromosome c, int n, Object[] args) {
        if (this.m_returnType == BooleanClass) {
            return new Boolean(this.execute_boolean(c, n, args));
        }
        if (this.m_returnType == IntegerClass) {
            return new Integer(this.execute_int(c, n, args));
        }
        if (this.m_returnType == LongClass) {
            return new Long(this.execute_long(c, n, args));
        }
        if (this.m_returnType == FloatClass) {
            return new Float(this.execute_float(c, n, args));
        }
        if (this.m_returnType == DoubleClass) {
            return new Double(this.execute_double(c, n, args));
        }
        if (this.m_returnType != VoidClass) {
            return this.execute_object(c, n, args);
        }
        this.execute_void(c, n, args);
        return null;
    }

    public Class getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(Class a_type) {
        this.m_returnType = a_type;
    }

    public boolean execute_boolean(ProgramChromosome c, int n, Object[] args) {
        throw new UnsupportedOperationException(this.getName() + " cannot return boolean");
    }

    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        throw new UnsupportedOperationException(this.getName() + " cannot return void");
    }

    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        throw new UnsupportedOperationException(this.getName() + " cannot return int");
    }

    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        throw new UnsupportedOperationException(this.getName() + " cannot return long");
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        throw new UnsupportedOperationException(this.getName() + " cannot return float");
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        throw new UnsupportedOperationException(this.getName() + " cannot return double");
    }

    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        throw new UnsupportedOperationException(this.getName() + " cannot return Object");
    }

    public String getName() {
        return this.toString() + " (class " + this.getClass().getName() + ")";
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        if (this.m_arity == 0) {
            return null;
        }
        return this.getReturnType();
    }

    protected Object getInternalValue() {
        return null;
    }

    public int hashCode() {
        if (this.getInternalValue() == null) {
            return this.getClass().getName().hashCode();
        }
        return this.getInternalValue().hashCode();
    }

    public boolean isIntegerType() {
        return this.m_integerType;
    }

    public boolean isFloatType() {
        return this.m_floatType;
    }

    public boolean isAffectGlobalState() {
        return false;
    }

    public boolean isValid(ProgramChromosome a_program) {
        return true;
    }

    public boolean isValid(ProgramChromosome a_program, int a_index) {
        return true;
    }

    protected void check(ProgramChromosome a_program) {
        if (this.m_noValidation) {
            return;
        }
        if (!this.isValid(a_program)) {
            throw new IllegalStateException("State for GP-command not valid");
        }
    }

    protected void check(ProgramChromosome a_program, int a_index) {
        if (this.m_noValidation) {
            return;
        }
        if (!this.isValid(a_program, a_index)) {
            throw new IllegalStateException("State for GP-command not valid");
        }
    }

    public void setNoValidation(boolean a_noValidation) {
        this.m_noValidation = a_noValidation;
    }

    public GPConfiguration getGPConfiguration() {
        return this.m_configuration;
    }

    public void setApplicationData(Object a_newData) {
        this.m_applicationData = a_newData;
    }

    public Object getApplicationData() {
        return this.m_applicationData;
    }

    public void setCompareApplicationData(boolean a_doCompare) {
        this.m_compareAppData = a_doCompare;
    }

    public boolean isCompareApplicationData() {
        return this.m_compareAppData;
    }

    public double getEnergy() {
        return this.m_energy;
    }

    public void setEnergy(double a_energy) {
        this.m_energy = a_energy;
    }

    public int getSubReturnType() {
        return this.m_subReturnType;
    }

    public int getSubChildType(int a_childNum) {
        if (this.m_subChildTypes == null) {
            return 0;
        }
        return this.m_subChildTypes[a_childNum];
    }

    public int[] getSubChildTypes() {
        return this.m_subChildTypes;
    }

    public void ensureUniqueness(ProgramChromosome a_program) {
        if (a_program.getCommandOfClass(1, this.getClass()) >= 0) {
            throw new IllegalStateException("Command " + this.getClass() + " must not occur more than once!");
        }
    }

    public void ensureUniqueness(ProgramChromosome a_program, int a_maxCount) {
        if (a_program.getCommandOfClass(1, this.getClass()) > a_maxCount) {
            throw new IllegalStateException("Command " + this.getClass() + " must not occur more than " + a_maxCount + " times!");
        }
    }

    public boolean ensureUniqueness2(ProgramChromosome a_program, int a_maxCount) {
        return a_program.getCommandOfClass(1, this.getClass()) <= a_maxCount;
    }

    protected COMMAND_TYPE getCommandType() {
        return COMMAND_TYPE.COMMAND_TYPE_UNDEFINED;
    }

    public String getPersistentRepresentation() {
        String s = this.m_returnType == null ? "null" : this.m_returnType.getClass().getName();
        String result = PERSISTENT_FIELD_DELIMITER + this.m_arity + PERSISTENT_FIELD_DELIMITER + s + PERSISTENT_FIELD_DELIMITER + this.m_subReturnType + PERSISTENT_FIELD_DELIMITER + this.m_subChildTypes + EXTENDED_INFO_DELIMITER + this.getPersistentRepresentationExt() + EXTENDED_INFO_DELIMITER;
        return result;
    }

    protected String getPersistentRepresentationExt() {
        return null;
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
    }

    protected void setValueFromString(int a_index, String a_value) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COMMAND_TYPE {
        COMMAND_TYPE_UNDEFINED(0),
        COMMAND_TYPE_LOOP(8),
        COMMAND_TYPE_CONDITIONAL(16),
        COMMAND_TYPE_OPERATION(32),
        COMMAND_TYPE_MATH_OPERATION(33),
        COMMAND_TYPE_DECLARATION(64),
        COMMAND_TYPE_ASSIGNMENT(128),
        COMMAND_TYPE_ANALYSIS(256),
        COMMAND_TYPE_EXECUTION(512);

        private int m_value;

        public int intValue() {
            return this.m_value;
        }

        private COMMAND_TYPE(int a_value) {
            this.m_value = a_value;
        }
    }
}

