/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.EolFormalParameter;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EolOperations
extends ArrayList<EolOperation> {
    public EolOperation getOperation(String name) {
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            EolOperation helper = (EolOperation)li.next();
            if (!helper.getName().equalsIgnoreCase(name)) continue;
            return helper;
        }
        return null;
    }

    public EolOperation getOperation(Object object, String name, List<?> parameters, IEolContext context) throws EolRuntimeException {
        EolOperation operation = this.getOperation(object, name, parameters, true, context);
        if (operation == null) {
            operation = this.getOperation(object, name, parameters, false, context);
        }
        return operation;
    }

    public EolOperation getOperation(Object object, String name, List<?> parameters, boolean ofTypeOnly, IEolContext context) throws EolRuntimeException {
        List<EolOperation> operations = this.getOperations(object, name, parameters, ofTypeOnly, context, true);
        if (operations.isEmpty()) {
            return null;
        }
        return operations.get(0);
    }

    public List<EolOperation> getOperations(Object object, String name, List<?> parameters, boolean ofTypeOnly, IEolContext context) throws EolRuntimeException {
        return this.getOperations(object, name, parameters, ofTypeOnly, context, false);
    }

    public List<EolOperation> getOperations(Object object, String name, List<?> parameters, boolean ofTypeOnly, IEolContext context, boolean returnOne) throws EolRuntimeException {
        ArrayList<EolOperation> operations = new ArrayList<EolOperation>();
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            EolOperation operation = (EolOperation)li.next();
            if (operation.getName().compareTo(name) != 0 || operation.getFormalParameters().size() != parameters.size()) continue;
            boolean correctContext = false;
            correctContext = ofTypeOnly ? operation.getContextType(context).isType(object) : operation.getContextType(context).isKind(object);
            if (!correctContext) continue;
            ListIterator<?> pi = parameters.listIterator();
            ListIterator fpi = operation.getFormalParameters().listIterator();
            boolean correctParameters = true;
            while (pi.hasNext()) {
                Object parameter = pi.next();
                EolFormalParameter formalParameter = (EolFormalParameter)fpi.next();
                if (ofTypeOnly) {
                    correctParameters = correctParameters && (formalParameter.getType(context).isType(parameter) || parameter == null);
                    continue;
                }
                boolean bl = correctParameters = correctParameters && (formalParameter.getType(context).isKind(parameter) || parameter == null);
            }
            if (!correctParameters) continue;
            operations.add(operation);
            if (!returnOne) continue;
            return operations;
        }
        return operations;
    }

    public EolOperation getOperation(Object source, AST operationAst, List<?> parameters, IEolContext context) throws EolRuntimeException {
        EolOperation operation = null;
        operation = this.getOperation(source, operationAst.getText(), parameters, true, context);
        if (operation == null) {
            operation = this.getOperation(source, operationAst.getText(), parameters, false, context);
        }
        return operation;
    }

    public Object execute(Object source, EolOperation helper, AST operationAst, ArrayList<?> parameters, IEolContext context) throws EolRuntimeException {
        return helper.execute(source, parameters, context);
    }
}

