/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementOperations
extends UMLUtil {
    protected ElementOperations() {
    }

    public static boolean validateNotOwnSelf(Element element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (EcoreUtil.isAncestor(element, (EObject)element.getOwner())) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 19, UMLPlugin.INSTANCE.getString("_UI_Element_NotOwnSelf_diagnostic", ElementOperations.getMessageSubstitutions(context, element)), new Object[]{element}));
            }
        }
        return result;
    }

    public static boolean validateHasOwner(Element element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (element.mustBeOwned() && element.getOwner() == null) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 18, UMLPlugin.INSTANCE.getString("_UI_Element_HasOwner_diagnostic", ElementOperations.getMessageSubstitutions(context, element)), new Object[]{element}));
            }
        }
        return result;
    }

    public static EList<EObject> getStereotypeApplications(Element element) {
        UniqueEList.FastCompare<EObject> stereotypeApplications = new UniqueEList.FastCompare<EObject>();
        for (EStructuralFeature.Setting setting : ElementOperations.getNonNavigableInverseReferences(element)) {
            EObject eObject;
            if (!setting.getEStructuralFeature().getName().startsWith("base_") || ElementOperations.getStereotype(eObject = setting.getEObject()) == null) continue;
            stereotypeApplications.add(eObject);
        }
        return ECollections.unmodifiableEList(stereotypeApplications);
    }

    public static EObject getStereotypeApplication(Element element, Stereotype stereotype) {
        for (EObject stereotypeApplication : element.getStereotypeApplications()) {
            if (ElementOperations.getStereotype(stereotypeApplication) != stereotype) continue;
            return stereotypeApplication;
        }
        return null;
    }

    public static EList<Stereotype> getRequiredStereotypes(Element element) {
        Package package_ = element.getNearestPackage();
        if (package_ != null) {
            UniqueEList.FastCompare<Stereotype> requiredStereotypes = new UniqueEList.FastCompare<Stereotype>();
            for (ProfileApplication profileApplication : package_.getAllProfileApplications()) {
                Profile appliedProfile = profileApplication.getAppliedProfile();
                if (appliedProfile == null) continue;
                for (Stereotype stereotype : appliedProfile.allApplicableStereotypes()) {
                    Extension extension;
                    ENamedElement appliedDefinition = profileApplication.getAppliedDefinition(stereotype);
                    if (!(appliedDefinition instanceof EClass) || ((EClass)appliedDefinition).isAbstract() || (extension = ElementOperations.getExtension(element, stereotype)) == null || !extension.isRequired()) continue;
                    requiredStereotypes.add(stereotype);
                }
            }
            return ECollections.unmodifiableEList(requiredStereotypes);
        }
        return ECollections.emptyEList();
    }

    public static Stereotype getRequiredStereotype(Element element, String qualifiedName) {
        for (Stereotype requiredStereotype : element.getRequiredStereotypes()) {
            if (!ElementOperations.safeEquals(requiredStereotype.getQualifiedName(), qualifiedName)) continue;
            return requiredStereotype;
        }
        return null;
    }

    public static EList<Stereotype> getAppliedStereotypes(Element element) {
        UniqueEList.FastCompare<Stereotype> appliedStereotypes = new UniqueEList.FastCompare<Stereotype>();
        for (EStructuralFeature.Setting setting : ElementOperations.getNonNavigableInverseReferences(element)) {
            Stereotype stereotype;
            if (!setting.getEStructuralFeature().getName().startsWith("base_") || (stereotype = ElementOperations.getStereotype(setting.getEObject())) == null) continue;
            appliedStereotypes.add(stereotype);
        }
        return ECollections.unmodifiableEList(appliedStereotypes);
    }

    public static Stereotype getAppliedStereotype(Element element, String qualifiedName) {
        for (Stereotype appliedStereotype : element.getAppliedStereotypes()) {
            if (!ElementOperations.safeEquals(appliedStereotype.getQualifiedName(), qualifiedName)) continue;
            return appliedStereotype;
        }
        return null;
    }

    public static EList<Stereotype> getAppliedSubstereotypes(Element element, Stereotype stereotype) {
        UniqueEList.FastCompare<Stereotype> appliedSubstereotypes = new UniqueEList.FastCompare<Stereotype>();
        for (Stereotype appliedStereotype : element.getAppliedStereotypes()) {
            if (!appliedStereotype.allParents().contains(stereotype)) continue;
            appliedSubstereotypes.add(appliedStereotype);
        }
        return ECollections.unmodifiableEList(appliedSubstereotypes);
    }

    public static Stereotype getAppliedSubstereotype(Element element, Stereotype stereotype, String qualifiedName) {
        for (Stereotype appliedSubstereotype : element.getAppliedSubstereotypes(stereotype)) {
            if (!ElementOperations.safeEquals(appliedSubstereotype.getQualifiedName(), qualifiedName)) continue;
            return appliedSubstereotype;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasValue(Element element, Stereotype stereotype, String propertyName) {
        EObject eObject = element.getStereotypeApplication(stereotype);
        if (eObject == null) return false;
        if (ElementOperations.isEmpty(propertyName)) return false;
        EClass eClass = eObject.eClass();
        String[] segments = propertyName.split("::");
        int i = 0;
        int length = segments.length;
        while (i < length) {
            String segment = segments[i];
            EStructuralFeature eStructuralFeature = null;
            int index = -1;
            if (segment.indexOf(91) == -1) {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier(segment));
            } else {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier(segment.substring(0, segment.indexOf(91))));
                try {
                    index = Integer.parseInt(segment.substring(segment.indexOf(91) + 1, segment.indexOf(93)));
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (eStructuralFeature != null) {
                if (length > i + 1) {
                    if (eObject == null) return false;
                    EClassifier eType = eStructuralFeature.getEType();
                    if (eType instanceof EClass) {
                        eClass = (EClass)eType;
                        if (eStructuralFeature.isMany()) {
                            List list = (List)eObject.eGet(eStructuralFeature);
                            eObject = (EObject)list.get(index);
                        } else {
                            eObject = (EObject)eObject.eGet(eStructuralFeature);
                        }
                    }
                } else {
                    if (eStructuralFeature.isMany()) {
                        List list;
                        List list2 = list = eObject == null ? Collections.emptyList() : (List)eObject.eGet(eStructuralFeature);
                        if (index == -1) {
                            if (!list.isEmpty()) return true;
                            return false;
                        }
                        if (!ElementOperations.safeEquals(eStructuralFeature.getDefaultValue(), list.get(index))) return true;
                        return false;
                    }
                    if (eObject == null) {
                        return false;
                    }
                    if (!ElementOperations.safeEquals(eStructuralFeature.getDefaultValue(), eObject.eGet(eStructuralFeature))) return true;
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    public static Object getValue(Element element, Stereotype stereotype, String propertyName) {
        if (stereotype == null || !element.isStereotypeApplied(stereotype)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (ElementOperations.isEmpty(propertyName)) {
            throw new IllegalArgumentException(String.valueOf(propertyName));
        }
        EObject eObject = element.getStereotypeApplication(stereotype);
        if (eObject == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EClass eClass = eObject.eClass();
        String[] segments = propertyName.split("::");
        int i = 0;
        int length = segments.length;
        while (i < length) {
            String segment = segments[i];
            EStructuralFeature eStructuralFeature = null;
            int index = -1;
            if (segment.indexOf(91) == -1) {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier(segment));
            } else {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier(segment.substring(0, segment.indexOf(91))));
                try {
                    index = Integer.parseInt(segment.substring(segment.indexOf(91) + 1, segment.indexOf(93)));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
            }
            if (eStructuralFeature == null) {
                throw new IllegalArgumentException(String.valueOf(propertyName));
            }
            EClassifier eType = eStructuralFeature.getEType();
            if (i + 1 < length) {
                if (eObject == null || !(eType instanceof EClass)) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                eClass = (EClass)eType;
                if (eStructuralFeature.isMany()) {
                    List list = (List)eObject.eGet(eStructuralFeature);
                    eObject = (EObject)list.get(index);
                } else {
                    eObject = (EObject)eObject.eGet(eStructuralFeature);
                }
            } else {
                Object reference;
                EList<EObject> references;
                EAnnotation eAnnotation;
                Object value = null;
                if (eStructuralFeature.isMany()) {
                    List list = eObject == null ? Collections.emptyList() : (List)eObject.eGet(eStructuralFeature);
                    value = index == -1 ? list : list.get(index);
                } else {
                    Object object = value = eObject == null ? eStructuralFeature.getDefaultValue() : eObject.eGet(eStructuralFeature);
                }
                if (eType instanceof EEnum && value instanceof EEnumLiteral && (eAnnotation = eType.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && (references = eAnnotation.getReferences()).size() > 0 && (reference = references.get(0)) instanceof Enumeration) {
                    value = ((Enumeration)reference).getOwnedLiteral(((EEnumLiteral)value).getName());
                }
                return value;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setValue(Element element, Stereotype stereotype, String propertyName, Object newValue) {
        if (stereotype == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (ElementOperations.isEmpty(propertyName)) {
            throw new IllegalArgumentException(String.valueOf(propertyName));
        }
        EObject eObject = element.getStereotypeApplication(stereotype);
        if (eObject == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EClass eClass = eObject.eClass();
        String[] segments = propertyName.split("::");
        int i = 0;
        int length = segments.length;
        while (i < length) {
            List list;
            String segment = segments[i];
            EStructuralFeature eStructuralFeature = null;
            int index = -1;
            if (segment.indexOf(91) == -1) {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier(segment));
            } else {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier(segment.substring(0, segment.indexOf(91))));
                try {
                    index = Integer.parseInt(segment.substring(segment.indexOf(91) + 1, segment.indexOf(93)));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
            }
            if (eStructuralFeature == null) {
                throw new IllegalArgumentException(String.valueOf(propertyName));
            }
            EClassifier eType = eStructuralFeature.getEType();
            if (i + 1 < length) {
                if (!(eType instanceof EClass)) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                eClass = (EClass)eType;
                if (eStructuralFeature.isMany()) {
                    list = (List)eObject.eGet(eStructuralFeature);
                    int size = list.size();
                    if (size <= index) {
                        if (!((EReference)eStructuralFeature).isContainment()) {
                            throw new IllegalArgumentException(String.valueOf(propertyName));
                        }
                        int j = size;
                        while (j <= index) {
                            list.add(j, EcoreUtil.create(eClass));
                            ++j;
                        }
                    }
                    eObject = (EObject)list.get(index);
                } else {
                    Object value = eObject.eGet(eStructuralFeature);
                    if (value == null) {
                        if (!((EReference)eStructuralFeature).isContainment()) {
                            throw new IllegalArgumentException(String.valueOf(propertyName));
                        }
                        value = EcoreUtil.create(eClass);
                        eObject.eSet(eStructuralFeature, value);
                    }
                    eObject = (EObject)value;
                }
            } else {
                if (newValue != null) {
                    if (eType instanceof EClass) {
                        EClass eClassType = (EClass)eType;
                        if (newValue instanceof List) {
                            Iterator j = ((List)newValue).iterator();
                            while (j.hasNext()) {
                                if (eClassType.isInstance(j.next())) continue;
                                throw new IllegalArgumentException(String.valueOf(newValue));
                            }
                        } else if (!eClassType.isInstance(newValue)) {
                            throw new IllegalArgumentException(String.valueOf(newValue));
                        }
                    } else if (eType instanceof EDataType) {
                        EDataType eDataType = (EDataType)eType;
                        EFactory eFactoryInstance = eDataType.getEPackage().getEFactoryInstance();
                        if (newValue instanceof List) {
                            ArrayList newList = new ArrayList(newValue);
                            if (eDataType instanceof EEnum) {
                                EEnum eEnum = (EEnum)eDataType;
                                ListIterator<Enumerator> li = newList.listIterator();
                                while (li.hasNext()) {
                                    Object item = li.next();
                                    if (!(item instanceof EnumerationLiteral)) continue;
                                    li.set(eEnum.getEEnumLiteral(((EnumerationLiteral)item).getName()).getInstance());
                                }
                            }
                            ListIterator<Object> li = newList.listIterator();
                            while (li.hasNext()) {
                                Object item = li.next();
                                if (!(item instanceof String)) continue;
                                try {
                                    li.set(eFactoryInstance.createFromString(eDataType, (String)item));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            newValue = newList;
                        } else {
                            if (eDataType instanceof EEnum) {
                                EEnum eEnum = (EEnum)eDataType;
                                if (newValue instanceof EnumerationLiteral) {
                                    newValue = eEnum.getEEnumLiteral(((EnumerationLiteral)((Object)newValue)).getName()).getInstance();
                                }
                            }
                            if (newValue instanceof String) {
                                try {
                                    newValue = eFactoryInstance.createFromString(eDataType, (String)((Object)newValue));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (newValue == null) {
                    newValue = eStructuralFeature.getDefaultValue();
                }
                if (eStructuralFeature.isMany()) {
                    if (index == -1) {
                        if (!(newValue instanceof List)) throw new IllegalArgumentException(String.valueOf(newValue));
                        eObject.eSet(eStructuralFeature, newValue);
                    } else {
                        list = (List)eObject.eGet(eStructuralFeature);
                        int j = list.size();
                        while (j < index) {
                            list.add(j, eStructuralFeature.getDefaultValue());
                            ++j;
                        }
                        if (index == list.size()) {
                            list.add(index, newValue);
                        } else {
                            list.set(index, newValue);
                        }
                    }
                } else {
                    eObject.eSet(eStructuralFeature, newValue);
                }
            }
            ++i;
        }
    }

    public static EAnnotation createEAnnotation(Element element, String source) {
        return ElementOperations.createEAnnotation(element, source);
    }

    public static EList<Relationship> getRelationships(Element element) {
        return ElementOperations.getRelationships(element, UMLPackage.Literals.RELATIONSHIP);
    }

    public static EList<Relationship> getRelationships(Element element, EClass eClass) {
        UniqueEList.FastCompare<Relationship> relationships = new UniqueEList.FastCompare<Relationship>();
        for (EStructuralFeature.Setting setting : ElementOperations.getNonNavigableInverseReferences(element)) {
            Association association;
            EObject eObject = setting.getEObject();
            if (eClass.isInstance(eObject)) {
                relationships.add((Relationship)eObject);
                continue;
            }
            if (!(eObject instanceof Property) || !eClass.isInstance(association = ((Property)eObject).getAssociation())) continue;
            relationships.add(association);
        }
        for (EReference eReference : element.eClass().getEAllReferences()) {
            if (eReference.isDerived() || !element.eIsSet(eReference)) continue;
            EClass eReferenceType = eReference.getEReferenceType();
            if (eClass.isSuperTypeOf(eReferenceType)) {
                if (eReference.isMany()) {
                    List values = (List)element.eGet(eReference);
                    relationships.addAll(values);
                    continue;
                }
                relationships.add((Relationship)element.eGet(eReference));
                continue;
            }
            if (!eReferenceType.isSuperTypeOf(eClass)) continue;
            Object value2 = element.eGet(eReference);
            if (eReference.isMany()) {
                for (Object value2 : (List)value2) {
                    if (!eClass.isInstance(value2)) continue;
                    relationships.add((Relationship)value2);
                }
                continue;
            }
            if (!eClass.isInstance(value2)) continue;
            relationships.add((Relationship)value2);
        }
        return ECollections.unmodifiableEList(relationships);
    }

    public static EList<DirectedRelationship> getSourceDirectedRelationships(Element element) {
        return ElementOperations.getSourceDirectedRelationships(element, UMLPackage.Literals.DIRECTED_RELATIONSHIP);
    }

    public static EList<DirectedRelationship> getSourceDirectedRelationships(Element element, EClass eClass) {
        UniqueEList.FastCompare<DirectedRelationship> sourceDirectedRelationships = new UniqueEList.FastCompare<DirectedRelationship>();
        for (DirectedRelationship directedRelationship : ElementOperations.getRelationships(element, eClass)) {
            if (!directedRelationship.getSources().contains(element)) continue;
            sourceDirectedRelationships.add(directedRelationship);
        }
        return ECollections.unmodifiableEList(sourceDirectedRelationships);
    }

    public static EList<DirectedRelationship> getTargetDirectedRelationships(Element element) {
        return ElementOperations.getTargetDirectedRelationships(element, UMLPackage.Literals.DIRECTED_RELATIONSHIP);
    }

    public static EList<DirectedRelationship> getTargetDirectedRelationships(Element element, EClass eClass) {
        UniqueEList.FastCompare<DirectedRelationship> targetDirectedRelationships = new UniqueEList.FastCompare<DirectedRelationship>();
        for (DirectedRelationship directedRelationship : ElementOperations.getRelationships(element, eClass)) {
            if (!directedRelationship.getTargets().contains(element)) continue;
            targetDirectedRelationships.add(directedRelationship);
        }
        return ECollections.unmodifiableEList(targetDirectedRelationships);
    }

    public static EList<String> getKeywords(Element element) {
        EMap<String, String> details;
        EAnnotation eAnnotation = element.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (eAnnotation != null && !(details = eAnnotation.getDetails()).isEmpty()) {
            UniqueEList<String> keywords = new UniqueEList<String>();
            Iterator d = details.iterator();
            while (d.hasNext()) {
                keywords.add((String)((Map.Entry)d.next()).getKey());
            }
            return ECollections.unmodifiableEList(keywords);
        }
        return ECollections.emptyEList();
    }

    public static boolean addKeyword(Element element, String keyword) {
        EMap<String, String> details = ElementOperations.getEAnnotation(element, "http://www.eclipse.org/uml2/2.0.0/UML", true).getDetails();
        if (!details.containsKey(keyword)) {
            details.put(keyword, null);
            return true;
        }
        return false;
    }

    public static boolean removeKeyword(Element element, String keyword) {
        EMap<String, String> details;
        EAnnotation eAnnotation = element.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (eAnnotation != null && (details = eAnnotation.getDetails()).containsKey(keyword)) {
            details.removeKey(keyword);
            return true;
        }
        return false;
    }

    public static Package getNearestPackage(Element element) {
        return (Package)(element instanceof Package ? element : ElementOperations.getOwningElement(element, UMLPackage.Literals.PACKAGE, true));
    }

    public static Model getModel(Element element) {
        return (Model)(element instanceof Model ? element : ElementOperations.getOwningElement(element, UMLPackage.Literals.MODEL, true));
    }

    protected static Extension getExtension(Element element, Stereotype stereotype) {
        for (Property attribute : stereotype.getAllAttributes()) {
            EClassifier eClassifier;
            Type type;
            String name;
            Association association = attribute.getAssociation();
            if (!(association instanceof Extension) || ElementOperations.isEmpty(name = attribute.getName()) || !name.startsWith("base_") || !((type = attribute.getType()) instanceof Class) || (eClassifier = ElementOperations.getEClassifier((Class)type)) == null || !eClassifier.isInstance(element)) continue;
            return (Extension)association;
        }
        return null;
    }

    protected static EClass getDefinition(Element element, Stereotype stereotype) {
        return ElementOperations.getDefinition(element, stereotype, false);
    }

    protected static EClass getDefinition(Element element, Stereotype stereotype, boolean required) {
        if (stereotype == null) {
            if (required) {
                throw new IllegalArgumentException("null stereotype");
            }
        } else {
            Profile profile = stereotype.getProfile();
            if (profile == null) {
                if (required) {
                    throw new IllegalArgumentException(String.format("stereotype \"%s\" is not in a profile", stereotype.getQualifiedName()));
                }
            } else {
                Package package_ = element.getNearestPackage();
                if (package_ == null) {
                    if (required) {
                        throw new IllegalArgumentException(String.format("element \"%s\" is not in a package", ElementOperations.getQualifiedText(element)));
                    }
                } else {
                    ProfileApplication profileApplication = package_.getProfileApplication(profile, true);
                    if (profileApplication == null) {
                        if (required) {
                            throw new IllegalArgumentException(String.format("profile \"%s\" is not applied", profile.getQualifiedName()));
                        }
                    } else {
                        ENamedElement appliedDefinition = profileApplication.getAppliedDefinition(stereotype);
                        if (appliedDefinition == null) {
                            if (required) {
                                throw new IllegalArgumentException(String.format("stereotype \"%s\" has no Ecore definition", stereotype.getQualifiedName()));
                            }
                        } else if (!(appliedDefinition instanceof EClass)) {
                            if (required) {
                                throw new IllegalArgumentException(String.format("stereotype \"%s\" definition is not an EClass", stereotype.getQualifiedName()));
                            }
                        } else {
                            EClass eClass = (EClass)appliedDefinition;
                            if (eClass.isAbstract()) {
                                if (required) {
                                    throw new IllegalArgumentException(String.format("stereotype \"%s\" Ecore definition is abstract", stereotype.getQualifiedName()));
                                }
                            } else {
                                return eClass;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    public static boolean isStereotypeApplicable(Element element, Stereotype stereotype) {
        return ElementOperations.getDefinition(element, stereotype) != null && ElementOperations.getExtension(element, stereotype) != null;
    }

    public static boolean isStereotypeRequired(Element element, Stereotype stereotype) {
        if (ElementOperations.getDefinition(element, stereotype) != null) {
            Extension extension = ElementOperations.getExtension(element, stereotype);
            return extension != null && extension.isRequired();
        }
        return false;
    }

    public static boolean isStereotypeApplied(Element element, Stereotype stereotype) {
        return element.getStereotypeApplication(stereotype) != null;
    }

    protected static EList<EObject> applyAllStereotypes(Element element, Map<EClassifier, Map<Stereotype, EClass>> definitions, EList<EObject> stereotypeApplications) {
        if (!element.eIsProxy()) {
            for (Map.Entry<EClassifier, Map<Stereotype, EClass>> stereotypeEntry : definitions.entrySet()) {
                if (!stereotypeEntry.getKey().isInstance(element)) continue;
                for (Map.Entry<Stereotype, EClass> definitionEntry : stereotypeEntry.getValue().entrySet()) {
                    if (element.isStereotypeApplied(definitionEntry.getKey())) continue;
                    stereotypeApplications.add(ElementOperations.applyStereotype(element, definitionEntry.getValue()));
                }
            }
        }
        return stereotypeApplications;
    }

    protected static EList<EObject> applyAllStereotypes(Element element, Map<EClassifier, Map<Stereotype, EClass>> definitions, boolean resolve) {
        UniqueEList.FastCompare<EObject> stereotypeApplications = new UniqueEList.FastCompare<EObject>();
        ElementOperations.applyAllStereotypes(element, definitions, stereotypeApplications);
        if (!element.eContents().isEmpty()) {
            TreeIterator allContents = EcoreUtil.getAllContents(element, resolve);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                ElementOperations.applyAllStereotypes((Element)eObject, definitions, stereotypeApplications);
            }
        }
        return stereotypeApplications;
    }

    public static EList<EObject> applyAllRequiredStereotypes(Element element) {
        return ElementOperations.applyAllRequiredStereotypes(element, true);
    }

    public static EList<EObject> applyAllRequiredStereotypes(Element element, boolean resolve) {
        Package package_ = element.getNearestPackage();
        if (package_ != null) {
            HashMap<EClassifier, Map<Stereotype, EClass>> definitions = new HashMap<EClassifier, Map<Stereotype, EClass>>();
            for (ProfileApplication profileApplication : package_.getAllProfileApplications()) {
                Profile appliedProfile = profileApplication.getAppliedProfile();
                if (appliedProfile == null) continue;
                for (Extension ownedExtension : appliedProfile.getOwnedExtensions(true)) {
                    ENamedElement appliedDefinition;
                    Stereotype stereotype;
                    EClassifier eClassifier;
                    Class metaclass = ownedExtension.getMetaclass();
                    if (metaclass == null || (eClassifier = ElementOperations.getEClassifier(metaclass)) == null || (stereotype = ownedExtension.getStereotype()) == null || !((appliedDefinition = profileApplication.getAppliedDefinition(stereotype)) instanceof EClass) || ((EClass)appliedDefinition).isAbstract()) continue;
                    HashMap<Stereotype, EClass> stereotypes = (HashMap<Stereotype, EClass>)definitions.get(eClassifier);
                    if (stereotypes == null) {
                        stereotypes = new HashMap<Stereotype, EClass>();
                        definitions.put(eClassifier, stereotypes);
                    }
                    if (stereotypes.containsKey(stereotype)) continue;
                    stereotypes.put(stereotype, (EClass)appliedDefinition);
                }
            }
            if (!definitions.isEmpty()) {
                return ElementOperations.applyAllStereotypes(element, definitions, resolve);
            }
        }
        return ECollections.emptyEList();
    }

    public static EObject applyStereotype(Element element, Stereotype stereotype) {
        EClass definition = ElementOperations.getDefinition(element, stereotype, true);
        if (ElementOperations.getExtension(element, stereotype) == null) {
            throw new IllegalArgumentException(String.format("stereotype \"%s\" is not applicable to %s", stereotype.getQualifiedName(), element.eClass().getName()));
        }
        if (element.getStereotypeApplication(stereotype) != null) {
            throw new IllegalArgumentException(String.format("stereotype \"%s\" is already applied", stereotype.getQualifiedName()));
        }
        return ElementOperations.applyStereotype(element, definition);
    }

    protected static EList<EObject> unapplyAllNonApplicableStereotypes(Element element, EList<EObject> nonApplicableStereotypes) {
        if (!element.eIsProxy()) {
            for (EObject stereotypeApplication : element.getStereotypeApplications()) {
                if (element.isStereotypeApplicable(ElementOperations.getStereotype(stereotypeApplication))) continue;
                nonApplicableStereotypes.add(stereotypeApplication);
                ElementOperations.destroy(stereotypeApplication);
            }
        }
        return nonApplicableStereotypes;
    }

    public static EList<EObject> unapplyAllNonApplicableStereotypes(Element element) {
        return ElementOperations.unapplyAllNonApplicableStereotypes(element, true);
    }

    public static EList<EObject> unapplyAllNonApplicableStereotypes(Element element, boolean resolve) {
        UniqueEList.FastCompare<EObject> nonApplicableStereotypes = new UniqueEList.FastCompare<EObject>();
        ElementOperations.unapplyAllNonApplicableStereotypes(element, nonApplicableStereotypes);
        if (!element.eContents().isEmpty()) {
            TreeIterator allContents = EcoreUtil.getAllContents(element, resolve);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                ElementOperations.unapplyAllNonApplicableStereotypes((Element)eObject, nonApplicableStereotypes);
            }
        }
        return nonApplicableStereotypes;
    }

    public static EObject unapplyStereotype(Element element, Stereotype stereotype) {
        if (stereotype == null) {
            throw new IllegalArgumentException("null stereotype");
        }
        if (element.isStereotypeRequired(stereotype)) {
            throw new IllegalArgumentException(String.format("stereotype \"%s\" is a required extension of %s", stereotype.getQualifiedName(), element.eClass().getName()));
        }
        EObject stereotypeApplication = element.getStereotypeApplication(stereotype);
        if (stereotypeApplication == null) {
            throw new IllegalArgumentException(String.format("stereotype \"%s\" is not applied", stereotype.getQualifiedName()));
        }
        ElementOperations.destroy(stereotypeApplication);
        return stereotypeApplication;
    }

    public static EList<Stereotype> getApplicableStereotypes(Element element) {
        Package package_ = element.getNearestPackage();
        if (package_ != null) {
            UniqueEList.FastCompare<Stereotype> applicableStereotypes = new UniqueEList.FastCompare<Stereotype>();
            for (ProfileApplication profileApplication : package_.getAllProfileApplications()) {
                Profile appliedProfile = profileApplication.getAppliedProfile();
                if (appliedProfile == null) continue;
                for (Stereotype stereotype : appliedProfile.allApplicableStereotypes()) {
                    ENamedElement appliedDefinition = profileApplication.getAppliedDefinition(stereotype);
                    if (!(appliedDefinition instanceof EClass) || ((EClass)appliedDefinition).isAbstract() || ElementOperations.getExtension(element, stereotype) == null) continue;
                    applicableStereotypes.add(stereotype);
                }
            }
            return ECollections.unmodifiableEList(applicableStereotypes);
        }
        return ECollections.emptyEList();
    }

    public static Stereotype getApplicableStereotype(Element element, String qualifiedName) {
        for (Stereotype applicableStereotype : element.getApplicableStereotypes()) {
            if (!ElementOperations.safeEquals(applicableStereotype.getQualifiedName(), qualifiedName)) continue;
            return applicableStereotype;
        }
        return null;
    }

    public static boolean hasKeyword(Element element, String keyword) {
        EAnnotation eAnnotation = element.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        return eAnnotation != null && eAnnotation.getDetails().containsKey(keyword);
    }

    public static void destroy(Element element) {
        ElementOperations.destroy((EObject)element);
    }

    protected static void destroy(EObject ancestorEObject) {
        if (ancestorEObject.eContents().isEmpty()) {
            if (ancestorEObject instanceof Element) {
                ElementOperations.destroyAll(((Element)ancestorEObject).getStereotypeApplications());
                ElementOperations.removeReferences(ancestorEObject, ancestorEObject);
                ancestorEObject.eAdapters().clear();
            } else {
                ElementOperations.removeReferences(ancestorEObject, null);
            }
        } else {
            EObject eObject;
            TreeIterator allContents = ElementOperations.getAllContents(ancestorEObject, true, false);
            while (allContents.hasNext()) {
                eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                ElementOperations.destroyAll(((Element)eObject).getStereotypeApplications());
            }
            allContents = ElementOperations.getAllContents(ancestorEObject, true, false);
            while (allContents.hasNext()) {
                eObject = (EObject)allContents.next();
                if (eObject instanceof Element) {
                    ElementOperations.removeReferences(eObject, ancestorEObject);
                    continue;
                }
                ElementOperations.removeReferences(eObject, null);
            }
            allContents = ElementOperations.getAllContents(ancestorEObject, true, false);
            while (allContents.hasNext()) {
                eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                eObject.eAdapters().clear();
            }
        }
        EcoreUtil.remove(ancestorEObject);
    }

    protected static void destroyAll(Collection<EObject> eObjects) {
        Iterator<EObject> o = eObjects.iterator();
        while (o.hasNext()) {
            ElementOperations.destroy(o.next());
        }
    }

    protected static EList<Element> allOwnedElements(Element element, EList<Element> allOwnedElements) {
        for (Element ownedElement : element.getOwnedElements()) {
            if (!allOwnedElements.add(ownedElement)) continue;
            ElementOperations.allOwnedElements(ownedElement, allOwnedElements);
        }
        return allOwnedElements;
    }

    public static EList<Element> allOwnedElements(Element element) {
        return ECollections.unmodifiableEList(ElementOperations.allOwnedElements(element, new UniqueEList.FastCompare<Element>()));
    }

    public static boolean mustBeOwned(Element element) {
        return true;
    }
}

