/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public class OneItemset
extends Itemset {
    int item;

    public OneItemset(int n) {
        this.item = n;
    }

    public OneItemset(int n, int n2) {
        this.item = n;
        this.support = n2;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public boolean containedIn(BitVector bitVector) {
        return bitVector.longValue(this.item) != 0L;
    }

    @Override
    public long[] getItems() {
        long[] lArray = BitsUtil.zero(this.item);
        BitsUtil.setI(lArray, this.item);
        return lArray;
    }

    public int hashCode() {
        return this.item;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Itemset) || ((Itemset)object).length() != 1) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OneItemset oneItemset = (OneItemset)object;
        return this.item == oneItemset.item;
    }

    @Override
    public int compareTo(Itemset itemset) {
        int n = Integer.compare(1, itemset.length());
        if (n != 0) {
            return n;
        }
        if (itemset instanceof OneItemset) {
            return Integer.compare(this.item, ((OneItemset)itemset).item);
        }
        throw new AbortException("Itemset of length 1 not using OneItemset!");
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation) {
        String string;
        String string2 = string = vectorFieldTypeInformation != null ? vectorFieldTypeInformation.getLabel(this.item) : null;
        if (string == null) {
            stringBuilder.append(this.item);
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.append(": ").append(this.support);
    }
}

