/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="S. Kullback", title="Information theory and statistics", booktitle="Information theory and statistics, Courier Dover Publications, 1997.")
@Alias(value={"kli"})
public class KullbackLeiblerDivergenceReverseAsymmetricDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    public static final KullbackLeiblerDivergenceReverseAsymmetricDistanceFunction STATIC = new KullbackLeiblerDivergenceReverseAsymmetricDistanceFunction();

    @Deprecated
    public KullbackLeiblerDivergenceReverseAsymmetricDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = KullbackLeiblerDivergenceReverseAsymmetricDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i);
            double d3 = numberVector2.doubleValue(i);
            if (d2 <= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (!(d3 > 0.0)) continue;
            d += d3 * Math.log(d3 / d2);
        }
        return d;
    }

    @Override
    public boolean isSymmetric() {
        return false;
    }

    public String toString() {
        return "KullbackLeiblerDivergenceDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return true;
        }
        return super.equals(object);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected KullbackLeiblerDivergenceReverseAsymmetricDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

