/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import java.awt.geom.Line2D;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class SelectionToolLineVisualization
extends AbstractVisFactory {
    private static final String NAME = "Object Selection";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            Relation relation = parallelPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 1000;
                visualizationTask.tool = true;
                visualizationTask.addUpdateFlags(2);
                visualizationTask.addFlags(5);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DragableArea.DragListener {
        private static final String CSS_RANGEMARKER = "selectionRangeMarker";
        Element rtag;
        Element etag;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g");
            SVGUtil.addCSSClass(this.rtag, CSS_RANGEMARKER);
            this.layer.appendChild(this.rtag);
            DragableArea dragableArea = new DragableArea((SVGPlot)this.svgp, -0.1 * this.getMarginLeft(), -0.5 * this.getMarginTop(), this.getSizeX() + 0.2 * this.getMarginLeft(), this.getMarginTop() * 1.5 + this.getSizeY(), this);
            this.etag = dragableArea.getElement();
            this.layer.appendChild(this.etag);
        }

        private void deleteChildren(Element element) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getLastChild());
            }
        }

        @Override
        public boolean startDrag(SVGPoint sVGPoint, Event event) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            this.deleteChildren(this.rtag);
            double d = Math.min(sVGPoint.getX(), sVGPoint2.getX());
            double d2 = Math.min(sVGPoint.getY(), sVGPoint2.getY());
            double d3 = Math.abs(sVGPoint.getX() - sVGPoint2.getX());
            double d4 = Math.abs(sVGPoint.getY() - sVGPoint2.getY());
            this.rtag.appendChild(this.svgp.svgRect(d, d2, d3, d4));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            Mode mode = this.getInputMode(event);
            this.deleteChildren(this.rtag);
            if (sVGPoint.getX() != sVGPoint2.getX() || sVGPoint.getY() != sVGPoint2.getY()) {
                this.updateSelection(mode, sVGPoint, sVGPoint2);
            }
            return true;
        }

        private Mode getInputMode(Event event) {
            if (event instanceof DOMMouseEvent) {
                DOMMouseEvent dOMMouseEvent = (DOMMouseEvent)event;
                if (dOMMouseEvent.getShiftKey()) {
                    return Mode.ADD;
                }
                if (dOMMouseEvent.getCtrlKey()) {
                    return Mode.INVERT;
                }
                return Mode.REPLACE;
            }
            return Mode.REPLACE;
        }

        private void updateSelection(Mode mode, SVGPoint sVGPoint, SVGPoint sVGPoint2) {
            DBIDSelection dBIDSelection = this.context.getSelection();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = dBIDSelection == null || mode == Mode.REPLACE ? DBIDUtil.newHashSet() : DBIDUtil.newHashSet(dBIDSelection.getSelectedIds());
            int[] nArray = this.getAxisRange(Math.min(sVGPoint.getX(), sVGPoint2.getX()), Math.max(sVGPoint.getX(), sVGPoint2.getX()));
            DBIDs dBIDs = ResultUtil.getSamplingResult(this.relation).getSample();
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get(dBIDIter));
                if (this.checkSelected(nArray, dArray, Math.max(sVGPoint.getX(), sVGPoint2.getX()), Math.min(sVGPoint.getX(), sVGPoint2.getX()), Math.max(sVGPoint.getY(), sVGPoint2.getY()), Math.min(sVGPoint.getY(), sVGPoint2.getY()))) {
                    if (mode == Mode.INVERT) {
                        if (!hashSetModifiableDBIDs.contains(dBIDIter)) {
                            hashSetModifiableDBIDs.add(dBIDIter);
                        } else {
                            hashSetModifiableDBIDs.remove(dBIDIter);
                        }
                    } else {
                        hashSetModifiableDBIDs.add(dBIDIter);
                    }
                }
                dBIDIter.advance();
            }
            this.context.setSelection(new DBIDSelection(hashSetModifiableDBIDs));
        }

        private int[] getAxisRange(double d, double d2) {
            int n = this.proj.getVisibleDimensions();
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            boolean bl2 = false;
            int n4 = -1;
            int n5 = 0;
            while (n5 < n) {
                if (bl && this.getVisibleAxisX(n5) > d) {
                    n2 = n4;
                    bl = false;
                    bl2 = true;
                }
                if (bl2 && (this.getVisibleAxisX(n5) > d2 || n5 == n - 1)) {
                    n3 = n4 + 1;
                    if (n5 != n - 1 || !(this.getVisibleAxisX(n5) <= d2)) break;
                    break;
                }
                n4 = n5++;
            }
            return new int[]{n2, ++n3};
        }

        private boolean checkSelected(int[] nArray, double[] dArray, double d, double d2, double d3, double d4) {
            int n = this.proj.getVisibleDimensions();
            if (nArray[0] < 0) {
                nArray[0] = 0;
            }
            if (nArray[1] >= n) {
                nArray[1] = n - 1;
            }
            for (int i = nArray[0] + 1; i <= nArray[1] - 1; ++i) {
                if (!(dArray[i] <= d3) || !(dArray[i] >= d4)) continue;
                return true;
            }
            Line2D.Double double_ = new Line2D.Double(this.getVisibleAxisX(nArray[0]), dArray[nArray[0]], this.getVisibleAxisX(nArray[0] + 1), dArray[nArray[0] + 1]);
            Line2D.Double double_2 = new Line2D.Double(this.getVisibleAxisX(nArray[1] - 1), dArray[nArray[1] - 1], this.getVisibleAxisX(nArray[1]), dArray[nArray[1]]);
            Line2D.Double double_3 = new Line2D.Double(d2, d3, d, d3);
            Line2D.Double double_4 = new Line2D.Double(d2, d3, d2, d4);
            Line2D.Double double_5 = new Line2D.Double(d2, d4, d, d4);
            if (double_.intersectsLine(double_3) || double_.intersectsLine(double_4) || double_.intersectsLine(double_5)) {
                return true;
            }
            Line2D.Double double_6 = new Line2D.Double(d, d3, d, d4);
            return double_2.intersectsLine(double_3) || double_2.intersectsLine(double_6) || double_2.intersectsLine(double_5);
        }

        protected void addCSSClasses(SVGPlot sVGPlot) {
            if (!sVGPlot.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass cSSClass = new CSSClass(this, CSS_RANGEMARKER);
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                cSSClass.setStatement("fill", styleLibrary.getColor("plot.selection.active"));
                cSSClass.setStatement("opacity", styleLibrary.getOpacity("plot.selection.active"));
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }

    private static enum Mode {
        REPLACE,
        ADD,
        INVERT;

    }
}

