/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cec2009Competition;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class UF6
extends AbstractDoubleProblem {
    int n;
    double epsilon;

    public UF6(String solutionType) throws ClassNotFoundException {
        this(30, 2, 0.1);
    }

    public UF6(Integer numberOfVariables, int N, double epsilon) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("UF6");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        this.n = N;
        this.epsilon = epsilon;
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-1.0);
            upperLimit.add(1.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count2 = 0;
        int count1 = 0;
        double prod2 = 1.0;
        double prod1 = 1.0;
        for (int j = 2; j <= this.getNumberOfVariables(); ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)this.getNumberOfVariables());
            double pj = Math.cos(20.0 * yj * Math.PI / Math.sqrt(j));
            if (j % 2 == 0) {
                sum2 += yj * yj;
                prod2 *= pj;
                ++count2;
                continue;
            }
            sum1 += yj * yj;
            prod1 *= pj;
            ++count1;
        }
        double hj = 2.0 * (0.5 / (double)this.n + this.epsilon) * Math.sin(2.0 * (double)this.n * Math.PI * x[0]);
        if (hj < 0.0) {
            hj = 0.0;
        }
        solution.setObjective(0, x[0] + hj + 2.0 * (4.0 * sum1 - 2.0 * prod1 + 2.0) / (double)count1);
        solution.setObjective(1, 1.0 - x[0] + hj + 2.0 * (4.0 * sum2 - 2.0 * prod2 + 2.0) / (double)count2);
    }
}

