/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.BitSet;
import org.uma.jmetal.problem.impl.AbstractBinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.solution.impl.DefaultBinarySolution;
import org.uma.jmetal.util.JMetalException;

public class OneMax
extends AbstractBinaryProblem {
    private int bits;

    public OneMax() {
        this(256);
    }

    public OneMax(Integer numberOfBits) {
        this.setNumberOfVariables(1);
        this.setNumberOfObjectives(1);
        this.setName("OneMax");
        this.bits = numberOfBits;
    }

    @Override
    protected int getBitsPerVariable(int index) {
        if (index != 0) {
            throw new JMetalException("Problem OneMax has only a variable. Index = " + index);
        }
        return this.bits;
    }

    @Override
    public BinarySolution createSolution() {
        return new DefaultBinarySolution(this);
    }

    @Override
    public void evaluate(BinarySolution solution) {
        int counterOnes = 0;
        BitSet bitset = (BitSet)solution.getVariableValue(0);
        for (int i = 0; i < bitset.length(); ++i) {
            if (!bitset.get(i)) continue;
            ++counterOnes;
        }
        solution.setObjective(0, -1.0 * (double)counterOnes);
    }
}

