/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public abstract class AbstractProjectedClustering<R extends Clustering<?>, V extends NumberVector>
extends AbstractAlgorithm<R>
implements ClusteringAlgorithm<R> {
    protected int k;
    protected int k_i;
    protected int l;
    private DistanceFunction<? super V> distanceFunction = EuclideanDistanceFunction.STATIC;

    public AbstractProjectedClustering(int n, int n2, int n3) {
        this.k = n;
        this.k_i = n2;
        this.l = n3;
    }

    protected DistanceFunction<? super V> getDistanceFunction() {
        return this.distanceFunction;
    }

    protected DistanceQuery<V> getDistanceQuery(Database database) {
        return QueryUtil.getDistanceQuery(database, this.distanceFunction, new Object[0]);
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID K_ID = new OptionID("projectedclustering.k", "The number of clusters to find.");
        public static final OptionID K_I_ID = new OptionID("projectedclustering.k_i", "The multiplier for the initial number of seeds.");
        public static final OptionID L_ID = new OptionID("projectedclustering.l", "The dimensionality of the clusters to find.");
        protected int k;
        protected int k_i;
        protected int l;

        protected void configK(Parameterization parameterization) {
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        protected void configKI(Parameterization parameterization) {
            IntParameter intParameter = new IntParameter(K_I_ID, 30);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k_i = (Integer)intParameter.getValue();
            }
        }

        protected void configL(Parameterization parameterization) {
            IntParameter intParameter = new IntParameter(L_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.l = (Integer)intParameter.getValue();
            }
        }
    }
}

