/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation.AffinityPropagationInitialization;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.LinearKernelFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class SimilarityBasedInitializationWithMedian<O>
implements AffinityPropagationInitialization<O> {
    SimilarityFunction<? super O> similarity;
    double quantile;

    public SimilarityBasedInitializationWithMedian(SimilarityFunction<? super O> similarityFunction, double d) {
        this.similarity = similarityFunction;
        this.quantile = d;
    }

    @Override
    public double[][] getSimilarityMatrix(Database database, Relation<O> relation, ArrayDBIDs arrayDBIDs) {
        int n;
        int n2 = arrayDBIDs.size();
        SimilarityQuery<O> similarityQuery = database.getSimilarityQuery(relation, this.similarity, new Object[0]);
        double[][] dArray = new double[n2][n2];
        double[] dArray2 = new double[n2 * (n2 - 1) >> 1];
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
        for (n = 0; n < n2; ++n) {
            dArray[n][n] = similarityQuery.similarity((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter) * 0.5;
            dBIDArrayIter.advance();
        }
        dBIDArrayIter.seek(0);
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            double[] dArray3 = dArray[n];
            dBIDArrayIter2.seek(n + 1);
            for (int i = n + 1; i < n2; ++i) {
                dArray3[i] = similarityQuery.similarity((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter2) - dArray3[n] - dArray[i][i];
                dArray[i][n] = dArray3[i];
                dArray2[n3] = dArray3[i];
                ++n3;
                dBIDArrayIter2.advance();
            }
            dBIDArrayIter.advance();
        }
        double d = QuickSelect.quantile(dArray2, this.quantile);
        for (int i = 0; i < n2; ++i) {
            dArray[i][i] = d;
        }
        return dArray;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.similarity.getInputTypeRestriction();
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID SIMILARITY_ID = new OptionID("ap.similarity", "Similarity function to use.");
        SimilarityFunction<? super O> similarity;
        double quantile;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(SIMILARITY_ID, (Class<?>)SimilarityFunction.class, LinearKernelFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.similarity = (SimilarityFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(AffinityPropagationInitialization.QUANTILE_ID, 0.5))) {
                this.quantile = doubleParameter.doubleValue();
            }
        }

        @Override
        protected SimilarityBasedInitializationWithMedian<O> makeInstance() {
            return new SimilarityBasedInitializationWithMedian<O>(this.similarity, this.quantile);
        }
    }
}

