/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.AbstractNumberVectorDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.RandomlyChosenInitialMeans;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractKMeans<V extends NumberVector, M extends Model>
extends AbstractNumberVectorDistanceBasedAlgorithm<V, Clustering<M>>
implements KMeans<V, M>,
ClusteringAlgorithm<Clustering<M>> {
    protected int k;
    protected int maxiter;
    protected KMeansInitialization<? super V> initializer;

    public AbstractKMeans(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super V> kMeansInitialization) {
        super(numberVectorDistanceFunction);
        this.k = n;
        this.maxiter = n2;
        this.initializer = kMeansInitialization;
    }

    protected boolean assignToNearestCluster(Relation<? extends V> relation, List<? extends NumberVector> list, List<? extends ModifiableDBIDs> list2, WritableIntegerDataStore writableIntegerDataStore, double[] dArray) {
        assert (this.k == list.size());
        boolean bl = false;
        Arrays.fill(dArray, 0.0);
        for (ModifiableDBIDs object2 : list2) {
            object2.clear();
        }
        DistanceFunction distanceFunction = this.getDistanceFunction();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = Double.POSITIVE_INFINITY;
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            int n = 0;
            for (int i = 0; i < this.k; ++i) {
                double d2 = distanceFunction.distance(numberVector, list.get(i));
                if (!(d2 < d)) continue;
                n = i;
                d = d2;
            }
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            list2.get(n).add(dBIDIter);
            bl |= writableIntegerDataStore.putInt(dBIDIter, n) != n;
            dBIDIter.advance();
        }
        return bl;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(TypeUtil.NUMBER_VECTOR_FIELD, this.getDistanceFunction().getInputTypeRestriction()));
    }

    protected List<Vector> means(List<? extends DBIDs> list, List<? extends NumberVector> list2, Relation<V> relation) {
        ArrayList<Vector> arrayList = new ArrayList<Vector>(this.k);
        for (int i = 0; i < this.k; ++i) {
            DBIDs dBIDs = list.get(i);
            Vector vector = null;
            if (dBIDs.size() > 0) {
                DBIDIter dBIDIter = dBIDs.iter();
                vector = ((NumberVector)relation.get(dBIDIter)).getColumnVector();
                double[] dArray = vector.getArrayRef();
                dBIDIter.advance();
                while (dBIDIter.valid()) {
                    NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
                    for (int j = 0; j < vector.getDimensionality(); ++j) {
                        int n = j;
                        dArray[n] = dArray[n] + numberVector.doubleValue(j);
                    }
                    dBIDIter.advance();
                }
                vector.timesEquals(1.0 / (double)dBIDs.size());
            } else {
                vector = list2.get(i).getColumnVector();
            }
            arrayList.add(vector);
        }
        return arrayList;
    }

    protected List<Vector> medians(List<? extends DBIDs> list, List<Vector> list2, Relation<V> relation) {
        int n = list2.get(0).getDimensionality();
        VectorUtil.SortDBIDsBySingleDimension sortDBIDsBySingleDimension = new VectorUtil.SortDBIDsBySingleDimension(relation);
        ArrayList<Vector> arrayList = new ArrayList<Vector>(this.k);
        for (int i = 0; i < this.k; ++i) {
            DBIDs dBIDs = list.get(i);
            if (dBIDs.size() <= 0) {
                arrayList.add(list2.get(i));
                continue;
            }
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
            DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
            Vector vector = new Vector(n);
            for (int j = 0; j < n; ++j) {
                sortDBIDsBySingleDimension.setDimension(j);
                dBIDArrayMIter.seek(QuickSelect.median(arrayModifiableDBIDs, sortDBIDsBySingleDimension));
                vector.set(j, ((NumberVector)relation.get(dBIDArrayMIter)).doubleValue(j));
            }
            arrayList.add(vector);
        }
        return arrayList;
    }

    protected void incrementalUpdateMean(Vector vector, V v, int n, double d) {
        if (n == 0) {
            return;
        }
        Vector vector2 = v.getColumnVector().minusEquals(vector);
        vector.plusTimesEquals(vector2, d / (double)n);
    }

    protected boolean macQueenIterate(Relation<V> relation, List<Vector> list, List<ModifiableDBIDs> list2, WritableIntegerDataStore writableIntegerDataStore, double[] dArray) {
        boolean bl = false;
        Arrays.fill(dArray, 0.0);
        DistanceFunction distanceFunction = this.getDistanceFunction();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = Double.POSITIVE_INFINITY;
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            int n = 0;
            for (int i = 0; i < this.k; ++i) {
                double d2 = distanceFunction.distance(numberVector, list.get(i));
                if (!(d2 < d)) continue;
                n = i;
                d = d2;
            }
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            bl |= this.updateMeanAndAssignment(list2, list, n, numberVector, dBIDIter, writableIntegerDataStore);
            dBIDIter.advance();
        }
        return bl;
    }

    private boolean updateMeanAndAssignment(List<ModifiableDBIDs> list, List<Vector> list2, int n, V v, DBIDIter dBIDIter, WritableIntegerDataStore writableIntegerDataStore) {
        int n2 = writableIntegerDataStore.intValue(dBIDIter);
        if (n2 == n) {
            return false;
        }
        ModifiableDBIDs modifiableDBIDs = list.get(n);
        modifiableDBIDs.add(dBIDIter);
        this.incrementalUpdateMean(list2.get(n), v, modifiableDBIDs.size(), 1.0);
        if (n2 >= 0) {
            ModifiableDBIDs modifiableDBIDs2 = list.get(n2);
            modifiableDBIDs2.remove(dBIDIter);
            this.incrementalUpdateMean(list2.get(n2), v, modifiableDBIDs2.size() + 1, -1.0);
        }
        writableIntegerDataStore.putInt(dBIDIter, n);
        return true;
    }

    @Override
    public void setK(int n) {
        this.k = n;
    }

    @Override
    public void setDistanceFunction(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction) {
        this.distanceFunction = numberVectorDistanceFunction;
    }

    protected void logVarstat(DoubleStatistic doubleStatistic, double[] dArray) {
        if (doubleStatistic == null) {
            return;
        }
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        doubleStatistic.setDouble(d);
        this.getLogger().statistics(doubleStatistic);
    }

    public static abstract class Parameterizer<V extends NumberVector>
    extends AbstractNumberVectorDistanceBasedAlgorithm.Parameterizer<V> {
        protected int k;
        protected int maxiter;
        protected KMeansInitialization<V> initializer;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.getParameterK(parameterization);
            this.getParameterInitialization(parameterization);
            this.getParameterDistanceFunction(parameterization);
            this.getParameterMaxIter(parameterization);
        }

        protected void getParameterK(Parameterization parameterization) {
            IntParameter intParameter = new IntParameter(KMeans.K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        protected void getParameterDistanceFunction(Parameterization parameterization) {
            ObjectParameter objectParameter = AbstractAlgorithm.makeParameterDistanceFunction(SquaredEuclideanDistanceFunction.class, PrimitiveDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distanceFunction = (NumberVectorDistanceFunction)objectParameter.instantiateClass(parameterization);
                if (!(this.distanceFunction instanceof EuclideanDistanceFunction) && !(this.distanceFunction instanceof SquaredEuclideanDistanceFunction)) {
                    this.getLogger().warning("k-means optimizes the sum of squares - it should be used with squared euclidean distance and may stop converging otherwise!");
                }
            }
        }

        protected void getParameterInitialization(Parameterization parameterization) {
            ObjectParameter objectParameter = new ObjectParameter(KMeans.INIT_ID, (Class<?>)KMeansInitialization.class, RandomlyChosenInitialMeans.class);
            if (parameterization.grab(objectParameter)) {
                this.initializer = (KMeansInitialization)objectParameter.instantiateClass(parameterization);
            }
        }

        protected void getParameterMaxIter(Parameterization parameterization) {
            IntParameter intParameter = new IntParameter(KMeans.MAXITER_ID, 0);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.maxiter = (Integer)intParameter.getValue();
            }
        }

        protected abstract Logging getLogger();

        @Override
        protected abstract AbstractKMeans<V, ?> makeInstance();
    }
}

