/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.ArrayList;
import java.util.List;

public class SingleAssignmentKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(SingleAssignmentKMeans.class);
    private static final String KEY = SingleAssignmentKMeans.class.getName();

    public SingleAssignmentKMeans(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, KMeansInitialization<? super V> kMeansInitialization) {
        super(numberVectorDistanceFunction, n, -1, kMeansInitialization);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        if (relation.size() <= 0) {
            return new Clustering<KMeansModel>("k-Means Assignment", "kmeans-assignment");
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, this.k, this.getDistanceFunction(), Vector.FACTORY);
        ArrayList<HashSetModifiableDBIDs> arrayList = new ArrayList<HashSetModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            arrayList.add(DBIDUtil.newHashSet((int)((double)relation.size() * 2.0 / (double)this.k)));
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        double[] dArray = new double[this.k];
        this.assignToNearestCluster(relation, list, arrayList, writableIntegerDataStore, dArray);
        Clustering<KMeansModel> clustering = new Clustering<KMeansModel>("Nearest Centroid Clustering", "nearest-center-clustering");
        for (int i = 0; i < arrayList.size(); ++i) {
            KMeansModel kMeansModel = new KMeansModel(list.get(i), dArray[i]);
            clustering.addToplevelCluster(new Cluster<KMeansModel>((DBIDs)arrayList.get(i), kMeansModel));
        }
        return clustering;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.getParameterDistanceFunction(parameterization);
            this.getParameterK(parameterization);
            this.getParameterInitialization(parameterization);
        }

        @Override
        protected SingleAssignmentKMeans<V> makeInstance() {
            return new SingleAssignmentKMeans(this.distanceFunction, this.k, this.initializer);
        }
    }
}

