/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="KNN outlier: Efficient Algorithms for Mining Outliers from Large Data Sets")
@Description(value="Outlier Detection based on the distance of an object to its k nearest neighbor.")
@Reference(authors="S. Ramaswamy, and R. Rastogi, and K. Shim", title="Efficient Algorithms for Mining Outliers from Large Data Sets", booktitle="Proc. Int. Conf. on Management of Data, 2000", url="http://dx.doi.org/10.1145/342009.335437")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.KNNOutlier", "knno"})
public class KNNOutlier<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KNNOutlier.class);
    private int k;

    public KNNOutlier(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.k = n + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        return this.run(relation);
    }

    public OutlierResult run(Relation<O> relation) {
        DistanceQuery<O> distanceQuery = relation.getDistanceQuery(this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = relation.getKNNQuery(distanceQuery, this.k);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("kNN distance for objects", relation.size(), LOG) : null;
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            double d = kNNQuery.getKNNForDBID((DBIDRef)object, this.k).getKNNDistance();
            writableDoubleDataStore.putDouble((DBIDRef)object, d);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            object.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object = new MaterializedDoubleRelation("kNN Outlier Score", "knn-outlier", writableDoubleDataStore, relation.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("knno.k", "The k nearest neighbor, excluding the query point (i.e. query point is the 0-nearest-neighbor)");
        protected int k = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected KNNOutlier<O> makeInstance() {
            return new KNNOutlier(this.distanceFunction, this.k);
        }
    }
}

