/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Title(value="LOCI: Fast Outlier Detection Using the Local Correlation Integral")
@Description(value="Algorithm to compute outliers based on the Local Correlation Integral")
@Reference(authors="S. Papadimitriou, H. Kitagawa, P. B. Gibbons, C. Faloutsos", title="LOCI: Fast Outlier Detection Using the Local Correlation Integral", booktitle="Proc. 19th IEEE Int. Conf. on Data Engineering (ICDE '03)", url="http://dx.doi.org/10.1109/ICDE.2003.1260802")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.ALOCI"})
public class ALOCI<O extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ALOCI.class);
    private int nmin;
    private int alpha;
    private int g;
    private RandomFactory rnd;
    private NumberVectorDistanceFunction<?> distFunc;

    public ALOCI(NumberVectorDistanceFunction<?> numberVectorDistanceFunction, int n, int n2, int n3, RandomFactory randomFactory) {
        this.distFunc = numberVectorDistanceFunction;
        this.nmin = n;
        this.alpha = n2;
        this.g = n3;
        this.rnd = randomFactory;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        int n;
        int n2 = RelationUtil.dimensionality(relation);
        Random random = this.rnd.getSingleThreadedRandom();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Build aLOCI quadtress", this.g, LOG) : null;
        Object object2 = RelationUtil.computeMinMax(relation);
        double[] dArray = object2[0];
        double[] dArray2 = object2[1];
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            d = MathUtil.max(d, dArray2[n] - dArray[n]);
        }
        n = 0;
        while (n < n2) {
            double d2 = (d - (dArray2[n] - dArray[n])) * 0.5;
            int n3 = n;
            dArray[n3] = dArray[n3] - d2;
            int n4 = n++;
            dArray2[n4] = dArray2[n4] + d2;
        }
        object2 = new ArrayList(this.g);
        double[] dArray3 = new double[n2];
        ALOCIQuadTree aLOCIQuadTree = new ALOCIQuadTree(dArray, dArray2, dArray3, this.nmin, relation);
        object2.add(aLOCIQuadTree);
        LOG.incrementProcessed(finiteProgress);
        for (n = 1; n < this.g; ++n) {
            double[] dArray4 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray4[i] = random.nextDouble() * (dArray2[i] - dArray[i]);
            }
            aLOCIQuadTree = new ALOCIQuadTree(dArray, dArray2, dArray4, this.nmin, relation);
            object2.add(aLOCIQuadTree);
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        FiniteProgress finiteProgress2 = LOG.isVerbose() ? new FiniteProgress("Compute aLOCI scores", relation.size(), LOG) : null;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        Object object3 = relation.iterDBIDs();
        while (object3.valid()) {
            object = (NumberVector)relation.get((DBIDRef)object3);
            double d3 = 0.0;
            int n5 = 0;
            while (true) {
                Node node = null;
                for (int i = 0; i < this.g; ++i) {
                    Node node2 = ((ALOCIQuadTree)object2.get(i)).findClosestNode((NumberVector)object, n5);
                    if (node2.getLevel() != n5 || node != null && !(this.distFunc.distance(node.getCenter(), (NumberVector)object) > this.distFunc.distance(node2.getCenter(), (NumberVector)object))) continue;
                    node = node2;
                }
                if (node == null) break;
                Node node3 = null;
                for (int i = 0; i < this.g; ++i) {
                    Node node4 = ((ALOCIQuadTree)object2.get(i)).findClosestNode(node.getCenter(), n5 - this.alpha);
                    if (node3 != null && node4.getLevel() < node3.getLevel() || node3 != null && !(this.distFunc.distance(node3.getCenter(), node.getCenter()) > this.distFunc.distance(node4.getCenter(), node.getCenter()))) continue;
                    node3 = node4;
                }
                if (node3 != null) {
                    double d4 = ALOCI.calculate_MDEF_norm(node3, node);
                    d3 = MathUtil.max(d3, d4);
                }
                ++n5;
            }
            writableDoubleDataStore.putDouble((DBIDRef)object3, d3);
            doubleMinMax.put(d3);
            LOG.incrementProcessed(finiteProgress2);
            object3.advance();
        }
        LOG.ensureCompleted(finiteProgress2);
        object3 = new MaterializedDoubleRelation("aLOCI normalized MDEF", "aloci-mdef-outlier", writableDoubleDataStore, relation.getDBIDs());
        object = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult outlierResult = new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object3);
        return outlierResult;
    }

    private static double calculate_MDEF_norm(Node node, Node node2) {
        long l = node.getSquareSum(node2.getLevel() - node.getLevel());
        if (l == (long)node.getCount()) {
            return 0.0;
        }
        long l2 = node.getCubicSum(node2.getLevel() - node.getLevel());
        double d = (double)l / (double)node.getCount();
        double d2 = Math.sqrt(l2 * (long)node.getCount() - l * l) / (double)node.getCount();
        if (d2 < Double.MIN_NORMAL) {
            return 0.0;
        }
        double d3 = d - (double)node2.getCount();
        return d3 / d2;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.distFunc.getInputTypeRestriction());
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID NMIN_ID = new OptionID("loci.nmin", "Minimum neighborhood size to be considered.");
        public static final OptionID ALPHA_ID = new OptionID("loci.alpha", "Scaling factor for averaging neighborhood");
        public static final OptionID GRIDS_ID = new OptionID("loci.g", "The number of Grids to use.");
        public static final OptionID SEED_ID = new OptionID("loci.seed", "The seed to use for initializing Random.");
        protected int nmin = 0;
        protected int alpha = 4;
        protected int g = 1;
        protected RandomFactory rnd;
        private NumberVectorDistanceFunction<?> distanceFunction;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            RandomParameter randomParameter;
            IntParameter intParameter2;
            IntParameter intParameter3;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = AbstractAlgorithm.makeParameterDistanceFunction(EuclideanDistanceFunction.class, NumberVectorDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distanceFunction = (NumberVectorDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(intParameter3 = new IntParameter(NMIN_ID, 20))) {
                this.nmin = (Integer)intParameter3.getValue();
            }
            if (parameterization.grab(intParameter2 = new IntParameter(GRIDS_ID, 1))) {
                this.g = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(ALPHA_ID, 4))) {
                this.alpha = (Integer)intParameter.getValue();
                if (this.alpha < 1) {
                    this.alpha = 1;
                }
            }
        }

        @Override
        protected ALOCI<O> makeInstance() {
            return new ALOCI(this.distanceFunction, this.nmin, this.alpha, this.g, this.rnd);
        }
    }

    static class Node {
        final int code;
        final int count;
        final int level;
        List<Node> children;
        Node parent = null;
        Vector center;

        protected Node(int n, Vector vector, int n2, int n3, List<Node> list) {
            this.code = n;
            this.center = vector;
            this.count = n2;
            this.level = n3;
            this.children = list;
            if (list != null) {
                for (Node node : list) {
                    node.parent = this;
                }
            }
        }

        public int getLevel() {
            return this.level;
        }

        public int getCount() {
            return this.count;
        }

        public Vector getCenter() {
            return this.center;
        }

        public long getSquareSum(int n) {
            if (n <= 0 || this.children == null) {
                return (long)this.count * (long)this.count;
            }
            long l = 0L;
            for (Node node : this.children) {
                l += node.getSquareSum(n - 1);
            }
            return l;
        }

        public long getCubicSum(int n) {
            if (n <= 0 || this.children == null) {
                return (long)this.count * (long)this.count * (long)this.count;
            }
            long l = 0L;
            for (Node node : this.children) {
                l += node.getCubicSum(n - 1);
            }
            return l;
        }
    }

    static class ALOCIQuadTree {
        private double[] shift;
        private double[] min;
        private double[] width;
        private int nmin;
        Node root;
        private Relation<? extends NumberVector> relation;

        public ALOCIQuadTree(double[] dArray, double[] dArray2, double[] dArray3, int n, Relation<? extends NumberVector> relation) {
            assert (dArray.length <= 32) : "Quadtrees are only supported for up to 32 dimensions";
            this.shift = dArray3;
            this.nmin = n;
            this.min = dArray;
            this.width = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.width[i] = dArray2[i] - dArray[i];
                if (!(this.width[i] <= 0.0)) continue;
                this.width[i] = 1.0;
            }
            double[] dArray4 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray4[i] = dArray3[i] < this.width[i] * 0.5 ? dArray[i] + dArray3[i] + this.width[i] * 0.5 : dArray[i] + dArray3[i] - this.width[i] * 0.5;
            }
            this.relation = relation;
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(relation.getDBIDs());
            ArrayList<Node> arrayList = new ArrayList<Node>();
            this.bulkLoad((double[])dArray.clone(), (double[])dArray2.clone(), arrayList, arrayModifiableDBIDs, 0, arrayModifiableDBIDs.size(), 0, 0, 0);
            this.root = new Node(0, new Vector(dArray4), arrayModifiableDBIDs.size(), -1, arrayList);
        }

        private void bulkLoad(double[] dArray, double[] dArray2, List<Node> list, ArrayModifiableDBIDs arrayModifiableDBIDs, int n, int n2, int n3, int n4, int n5) {
            int n6;
            Object object;
            Object object2;
            if (n3 == 0) {
                int n7;
                Object object3;
                object2 = arrayModifiableDBIDs.iter();
                object2.seek(n);
                object = this.relation.get((DBIDRef)object2);
                object2.advance();
                n6 = 1;
                block0: while (object2.getOffset() < n2) {
                    object3 = this.relation.get((DBIDRef)object2);
                    for (n7 = 0; n7 < dArray.length; ++n7) {
                        if (!(Math.abs(object.doubleValue(n7) - object3.doubleValue(n7)) > 1.0E-15)) continue;
                        n6 = 0;
                        break block0;
                    }
                    object2.advance();
                }
                if (n6 != 0) {
                    object3 = new double[dArray.length];
                    for (n7 = 0; n7 < dArray.length; ++n7) {
                        object3[n7] = dArray[n7] * 0.5 + dArray2[n7] * 0.5 + this.shift[n7];
                        if (!(object3[n7] > this.min[n7] + this.width[n7])) continue;
                        Object object4 = object3;
                        int n8 = n7;
                        object4[n8] = object4[n8] - this.width[n7];
                    }
                    list.add(new Node(n5, new Vector((double[])object3), n2 - n, n4, null));
                    return;
                }
            }
            if (n3 == dArray.length) {
                object2 = new double[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    object2[i] = dArray[i] * 0.5 + dArray2[i] * 0.5 + this.shift[i];
                    if (!(object2[i] > this.min[i] + this.width[i])) continue;
                    Object object5 = object2;
                    int n9 = i;
                    object5[n9] = object5[n9] - this.width[i];
                }
                if (n2 - n < this.nmin) {
                    list.add(new Node(n5, new Vector((double[])object2), n2 - n, n4, null));
                    return;
                }
                ArrayList<Node> arrayList = new ArrayList<Node>();
                this.bulkLoad(dArray, dArray2, arrayList, arrayModifiableDBIDs, n, n2, 0, n4 + 1, 0);
                list.add(new Node(n5, new Vector((double[])object2), n2 - n, n4, arrayList));
                return;
            }
            object2 = arrayModifiableDBIDs.iter();
            object = arrayModifiableDBIDs.iter();
            object2.seek(n);
            object.seek(n2 - 1);
            while (object2.getOffset() < object.getOffset()) {
                if (this.getShiftedDim(this.relation.get((DBIDRef)object2), n3, n4) <= 0.5) {
                    object2.advance();
                    continue;
                }
                if (this.getShiftedDim(this.relation.get((DBIDRef)object), n3, n4) > 0.5) {
                    object.retract();
                    continue;
                }
                arrayModifiableDBIDs.swap(object2.getOffset(), object.getOffset() - 1);
                object2.advance();
                object.retract();
            }
            n6 = object2.getOffset();
            if (n < n6) {
                double d = dArray2[n3];
                dArray2[n3] = dArray2[n3] * 0.5 + dArray[n3] * 0.5;
                this.bulkLoad(dArray, dArray2, list, arrayModifiableDBIDs, n, n6, n3 + 1, n4, n5);
                dArray2[n3] = d;
            }
            if (n6 < n2) {
                double d = dArray[n3];
                dArray[n3] = dArray2[n3] * 0.5 + dArray[n3] * 0.5;
                this.bulkLoad(dArray, dArray2, list, arrayModifiableDBIDs, n6, n2, n3 + 1, n4, n5 | 1 << n3);
                dArray[n3] = d;
            }
        }

        private double getShiftedDim(NumberVector numberVector, int n, int n2) {
            double d = numberVector.doubleValue(n) + this.shift[n];
            d = (d - this.min[n]) / this.width[n] * (double)(1 + n2);
            return d - Math.floor(d);
        }

        public Node findClosestNode(NumberVector numberVector, int n) {
            Node node = this.root;
            for (int i = 0; i <= n && node.children != null; ++i) {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < this.min.length; ++n2) {
                    if (!(this.getShiftedDim(numberVector, n2, i) > 0.5)) continue;
                    n3 |= 1 << n2;
                }
                n2 = 0;
                for (Node node2 : node.children) {
                    if (node2.code != n3) continue;
                    node = node2;
                    n2 = 1;
                    break;
                }
                if (n2 == 0) break;
            }
            return node;
        }
    }
}

