/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.GEDEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class EstimateIntrinsicDimensionality<O>
extends AbstractDistanceBasedAlgorithm<O, Result> {
    private static final Logging LOG = Logging.getLogger(EstimateIntrinsicDimensionality.class);
    protected double krate;
    protected double samples;
    protected IntrinsicDimensionalityEstimator estimator;

    public EstimateIntrinsicDimensionality(DistanceFunction<? super O> distanceFunction, IntrinsicDimensionalityEstimator intrinsicDimensionalityEstimator, double d, double d2) {
        super(distanceFunction);
        this.estimator = intrinsicDimensionalityEstimator;
        this.krate = d;
        this.samples = d2;
    }

    public Result run(Database database, Relation<O> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        int n = (int)(this.samples > 1.0 ? this.samples : Math.ceil(this.samples * (double)dBIDs.size()));
        int n2 = 1 + (int)(this.krate > 1.0 ? this.krate : Math.ceil(this.krate * (double)dBIDs.size()));
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(dBIDs, n, RandomFactory.DEFAULT);
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, n2);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n3 = 0;
        DBIDIter dBIDIter = modifiableDBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, n2);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid() && doubleDBIDListIter.doubleValue() == 0.0) {
                doubleDBIDListIter.advance();
            }
            if (doubleDBIDListIter.valid()) {
                double[] dArray3 = new double[kNNList.size() - doubleDBIDListIter.getOffset()];
                int n4 = 0;
                while (doubleDBIDListIter.valid()) {
                    dArray3[n4] = doubleDBIDListIter.doubleValue();
                    doubleDBIDListIter.advance();
                    ++n4;
                }
                dArray2[n3] = dArray3[dArray3.length - 1];
                dArray[n3] = this.estimator.estimate(dArray3);
                ++n3;
            }
            dBIDIter.advance();
        }
        double d = n3 > 1 ? QuickSelect.median(dArray, 0, n3) : -1.0;
        double d2 = n3 > 1 ? QuickSelect.median(dArray2, 0, n3) : 0.0;
        LOG.statistics(new DoubleStatistic(EstimateIntrinsicDimensionality.class.getName() + ".k-distance", d2));
        LOG.statistics(new DoubleStatistic(EstimateIntrinsicDimensionality.class.getName() + ".intrinsic-dimensionality", d));
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID ESTIMATOR_ID = new OptionID("idist.estimator", "Estimation method for intrinsic dimensionality.");
        public static final OptionID KRATE_ID = new OptionID("idist.k", "Number of kNN (absolute or relative)");
        public static final OptionID SAMPLES_ID = new OptionID("idist.sampling", "Sample size (absolute or relative)");
        protected IntrinsicDimensionalityEstimator estimator;
        protected double krate;
        protected double samples;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(ESTIMATOR_ID, (Class<?>)IntrinsicDimensionalityEstimator.class, GEDEstimator.class);
            if (parameterization.grab(objectParameter)) {
                this.estimator = (IntrinsicDimensionalityEstimator)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter2 = (DoubleParameter)new DoubleParameter(KRATE_ID, 50.0).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.krate = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SAMPLES_ID, 0.1))) {
                this.samples = doubleParameter.doubleValue();
            }
        }

        @Override
        protected EstimateIntrinsicDimensionality<O> makeInstance() {
            return new EstimateIntrinsicDimensionality(this.distanceFunction, this.estimator, this.krate, this.samples);
        }
    }
}

