/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteVector
extends AbstractNumberVector {
    public static final Factory STATIC = new Factory();
    public static final ByteBufferSerializer<ByteVector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<ByteVector> SHORT_SERIALIZER = new ShortSerializer();
    private final byte[] values;

    private ByteVector(byte[] byArray, boolean bl) {
        if (bl) {
            this.values = byArray;
        } else {
            this.values = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.values, 0, byArray.length);
        }
    }

    public ByteVector(byte[] byArray) {
        this.values = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.values, 0, byArray.length);
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Byte getValue(int n) {
        return this.values[n];
    }

    @Override
    public double doubleValue(int n) {
        return this.values[n];
    }

    @Override
    public long longValue(int n) {
        return this.values[n];
    }

    @Override
    public byte byteValue(int n) {
        return this.values[n];
    }

    public byte[] getValues() {
        byte[] byArray = new byte[this.values.length];
        System.arraycopy(this.values, 0, byArray, 0, this.values.length);
        return byArray;
    }

    @Override
    public Vector getColumnVector() {
        double[] dArray = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            dArray[i] = this.values[i];
        }
        return new Vector(dArray);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<ByteVector> {
        @Override
        public ByteVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getShort();
            assert (byteBuffer.remaining() >= 1 * n);
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = byteBuffer.get();
            }
            return new ByteVector(byArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, ByteVector byteVector) throws IOException {
            assert (byteVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (byteBuffer.remaining() >= 1 * byteVector.values.length);
            byteBuffer.putShort((short)byteVector.values.length);
            for (int i = 0; i < byteVector.values.length; ++i) {
                byteBuffer.put(byteVector.values[i]);
            }
        }

        @Override
        public int getByteSize(ByteVector byteVector) {
            assert (byteVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 1 * byteVector.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<ByteVector> {
        @Override
        public ByteVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.get();
            assert (byteBuffer.remaining() >= 1 * n);
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = byteBuffer.get();
            }
            return new ByteVector(byArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, ByteVector byteVector) throws IOException {
            assert (byteVector.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (byteBuffer.remaining() >= 1 * byteVector.values.length);
            byteBuffer.put((byte)byteVector.values.length);
            for (int i = 0; i < byteVector.values.length; ++i) {
                byteBuffer.put(byteVector.values[i]);
            }
        }

        @Override
        public int getByteSize(ByteVector byteVector) {
            assert (byteVector.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 1 * byteVector.getDimensionality();
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<ByteVector> {
        @Override
        public <A> ByteVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = arrayAdapter.get(a, i).byteValue();
            }
            return new ByteVector(byArray, true);
        }

        @Override
        public <A> ByteVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = numberArrayAdapter.getByte(a, i);
            }
            return new ByteVector(byArray, true);
        }

        @Override
        public ByteBufferSerializer<ByteVector> getDefaultSerializer() {
            return SHORT_SERIALIZER;
        }

        @Override
        public Class<? super ByteVector> getRestrictionClass() {
            return ByteVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return STATIC;
            }
        }
    }
}

