/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.model;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.model.PrototypeModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;

public final class ModelUtil {
    public static <V extends NumberVector> V getPrototype(Model model, Relation<? extends V> relation, NumberVector.Factory<V> factory) {
        if (model instanceof MeanModel) {
            Vector vector = ((MeanModel)model).getMean();
            if (factory.getRestrictionClass().isInstance(vector)) {
                return (V)vector;
            }
            return factory.newNumberVector(vector.getArrayRef());
        }
        if (model instanceof MedoidModel) {
            NumberVector numberVector = (NumberVector)relation.get(((MedoidModel)model).getMedoid());
            if (factory.getRestrictionClass().isInstance(numberVector)) {
                return (V)numberVector;
            }
            return factory.newNumberVector(numberVector, ArrayLikeUtil.NUMBERVECTORADAPTER);
        }
        if (model instanceof PrototypeModel) {
            Object v = ((PrototypeModel)model).getPrototype();
            if (factory.getRestrictionClass().isInstance(v)) {
                return (V)((NumberVector)v);
            }
            if (v instanceof NumberVector) {
                return factory.newNumberVector((NumberVector)v, ArrayLikeUtil.NUMBERVECTORADAPTER);
            }
            return null;
        }
        return null;
    }

    public static NumberVector getPrototype(Model model, Relation<? extends NumberVector> relation) {
        if (model instanceof MeanModel) {
            return ((MeanModel)model).getMean();
        }
        if (model instanceof MedoidModel) {
            return relation.get(((MedoidModel)model).getMedoid());
        }
        if (model instanceof PrototypeModel) {
            Object v = ((PrototypeModel)model).getPrototype();
            if (v instanceof NumberVector) {
                return (NumberVector)v;
            }
            return null;
        }
        return null;
    }

    public static <V extends NumberVector> V getPrototypeOrCentroid(Model model, Relation<? extends V> relation, DBIDs dBIDs, NumberVector.Factory<V> factory) {
        assert (dBIDs.size() > 0);
        V v = ModelUtil.getPrototype(model, relation, factory);
        return v != null ? v : factory.newNumberVector(Centroid.make(relation, dBIDs));
    }

    public static NumberVector getPrototypeOrCentroid(Model model, Relation<? extends NumberVector> relation, DBIDs dBIDs) {
        assert (dBIDs.size() > 0);
        NumberVector numberVector = ModelUtil.getPrototype(model, relation);
        return numberVector != null ? numberVector : Centroid.make(relation, dBIDs);
    }
}

