/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.spatial;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;

public final class SpatialUtil {
    private SpatialUtil() {
    }

    public static int assertSameDimensionality(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = spatialComparable.getDimensionality();
        if (n != spatialComparable2.getDimensionality()) {
            throw new IllegalArgumentException("The spatial objects do not have the same dimensionality!");
        }
        return n;
    }

    public static double[] getMin(SpatialComparable spatialComparable) {
        int n = spatialComparable.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = spatialComparable.getMin(i);
        }
        return dArray;
    }

    public static double[] getMax(SpatialComparable spatialComparable) {
        int n = spatialComparable.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = spatialComparable.getMax(i);
        }
        return dArray;
    }

    public static boolean intersects(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        for (int i = 0; i < n; ++i) {
            if (!(spatialComparable2.getMax(i) < spatialComparable.getMin(i)) && !(spatialComparable.getMax(i) < spatialComparable2.getMin(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        for (int i = 0; i < n; ++i) {
            if (!(spatialComparable2.getMin(i) < spatialComparable.getMin(i)) && !(spatialComparable.getMax(i) < spatialComparable2.getMax(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(SpatialComparable spatialComparable, double[] dArray) {
        int n = spatialComparable.getDimensionality();
        if (n != dArray.length) {
            throw new IllegalArgumentException("This HyperBoundingBox and the given point need same dimensionality");
        }
        for (int i = 0; i < n; ++i) {
            if (!(spatialComparable.getMin(i) > dArray[i]) && !(spatialComparable.getMax(i) < dArray[i])) continue;
            return false;
        }
        return true;
    }

    public static double volume(SpatialComparable spatialComparable) {
        int n = spatialComparable.getDimensionality();
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            double d2 = spatialComparable.getMax(i) - spatialComparable.getMin(i);
            if (d2 == 0.0) {
                return 0.0;
            }
            d *= d2;
        }
        return d;
    }

    public static double volumeUnion(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            double d2 = Math.min(spatialComparable.getMin(i), spatialComparable2.getMin(i));
            double d3 = Math.max(spatialComparable.getMax(i), spatialComparable2.getMax(i));
            d *= d3 - d2;
        }
        return d;
    }

    public static double volumeScaled(SpatialComparable spatialComparable, double d) {
        int n = spatialComparable.getDimensionality();
        double d2 = 1.0;
        for (int i = 0; i < n; ++i) {
            double d3 = spatialComparable.getMax(i) - spatialComparable.getMin(i);
            if (d3 == 0.0) {
                return 0.0;
            }
            d2 *= d3 * d;
        }
        return d2;
    }

    public static double volumeUnionScaled(SpatialComparable spatialComparable, SpatialComparable spatialComparable2, double d) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        double d2 = 1.0;
        for (int i = 0; i < n; ++i) {
            double d3 = Math.min(spatialComparable.getMin(i), spatialComparable2.getMin(i));
            double d4 = Math.max(spatialComparable.getMax(i), spatialComparable2.getMax(i));
            d2 *= (d4 - d3) * d;
        }
        return d2;
    }

    public static double enlargement(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        double d = 1.0;
        double d2 = 1.0;
        for (int i = 0; i < n; ++i) {
            double d3 = spatialComparable.getMin(i);
            double d4 = spatialComparable.getMax(i);
            double d5 = spatialComparable2.getMin(i);
            double d6 = spatialComparable2.getMax(i);
            double d7 = Math.min(d3, d5);
            double d8 = Math.max(d4, d6);
            d *= d8 - d7;
            d2 *= d4 - d3;
        }
        return d2 - d;
    }

    public static double enlargementScaled(SpatialComparable spatialComparable, SpatialComparable spatialComparable2, double d) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        double d2 = 1.0;
        double d3 = 1.0;
        for (int i = 0; i < n; ++i) {
            double d4 = spatialComparable.getMin(i);
            double d5 = spatialComparable.getMax(i);
            double d6 = spatialComparable2.getMin(i);
            double d7 = spatialComparable2.getMax(i);
            double d8 = Math.min(d4, d6);
            double d9 = Math.max(d5, d7);
            d2 *= (d9 - d8) * d;
            d3 *= (d5 - d4) * d;
        }
        return d3 - d2;
    }

    public static double perimeter(SpatialComparable spatialComparable) {
        int n = spatialComparable.getDimensionality();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += spatialComparable.getMax(i) - spatialComparable.getMin(i);
        }
        return d;
    }

    public static double overlap(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = Math.min(spatialComparable.getMax(i), spatialComparable2.getMax(i));
            if (d3 <= (d2 = Math.max(spatialComparable.getMin(i), spatialComparable2.getMin(i)))) {
                return 0.0;
            }
            d *= d3 - d2;
        }
        return d;
    }

    public static double relativeOverlap(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        for (int i = 0; i < n; ++i) {
            double d4;
            double d5 = spatialComparable.getMin(i);
            double d6 = spatialComparable.getMax(i);
            double d7 = spatialComparable2.getMin(i);
            double d8 = spatialComparable2.getMax(i);
            double d9 = Math.min(d6, d8);
            if (d9 <= (d4 = Math.max(d5, d7))) {
                return 0.0;
            }
            d *= d9 - d4;
            d2 *= d6 - d5;
            d3 *= d8 - d7;
        }
        return d / (d2 + d3);
    }

    public static ModifiableHyperBoundingBox union(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.min(spatialComparable.getMin(i), spatialComparable2.getMin(i));
            dArray2[i] = Math.max(spatialComparable.getMax(i), spatialComparable2.getMax(i));
        }
        return new ModifiableHyperBoundingBox(dArray, dArray2);
    }

    public static ModifiableHyperBoundingBox unionTolerant(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable == null && spatialComparable2 == null) {
            return null;
        }
        if (spatialComparable == null) {
            return new ModifiableHyperBoundingBox(spatialComparable2);
        }
        if (spatialComparable2 == null) {
            return new ModifiableHyperBoundingBox(spatialComparable);
        }
        return SpatialUtil.union(spatialComparable, spatialComparable2);
    }

    public static <E extends SpatialComparable, A> double[] unionFlatMBR(A a, ArrayAdapter<E, ? super A> arrayAdapter) {
        int n = arrayAdapter.size(a);
        assert (n > 0) : "Cannot compute MBR of empty set.";
        SpatialComparable spatialComparable = (SpatialComparable)arrayAdapter.get(a, 0);
        int n2 = spatialComparable.getDimensionality();
        double[] dArray = new double[2 * n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = spatialComparable.getMin(i);
            dArray[n2 + i] = spatialComparable.getMax(i);
        }
        for (int i = 1; i < n; ++i) {
            SpatialComparable spatialComparable2 = (SpatialComparable)arrayAdapter.get(a, i);
            for (int j = 0; j < n2; ++j) {
                dArray[j] = Math.min(dArray[j], spatialComparable2.getMin(j));
                dArray[n2 + j] = Math.max(dArray[n2 + j], spatialComparable2.getMax(j));
            }
        }
        return dArray;
    }

    public static ModifiableHyperBoundingBox intersection(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = SpatialUtil.assertSameDimensionality(spatialComparable, spatialComparable2);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.max(spatialComparable.getMin(i), spatialComparable2.getMin(i));
            dArray2[i] = Math.min(spatialComparable.getMax(i), spatialComparable2.getMax(i));
            if (!(dArray[i] > dArray2[i])) continue;
            return null;
        }
        return new ModifiableHyperBoundingBox(dArray, dArray2);
    }

    public static double[] centroid(SpatialComparable spatialComparable) {
        int n = spatialComparable.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (spatialComparable.getMax(i) + spatialComparable.getMin(i)) * 0.5;
        }
        return dArray;
    }

    public static boolean equals(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable.getDimensionality() != spatialComparable2.getDimensionality()) {
            return false;
        }
        for (int i = 0; i < spatialComparable.getDimensionality(); ++i) {
            if (spatialComparable.getMin(i) != spatialComparable2.getMin(i)) {
                return false;
            }
            if (spatialComparable.getMax(i) == spatialComparable2.getMax(i)) continue;
            return false;
        }
        return true;
    }
}

