/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomDoubleVectorDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(RandomDoubleVectorDatabaseConnection.class);
    protected int dim = -1;
    protected int size = -1;
    protected RandomFactory rnd;

    public RandomDoubleVectorDatabaseConnection(int n, int n2, RandomFactory randomFactory, List<ObjectFilter> list) {
        super(list);
        this.dim = n;
        this.size = n2;
        this.rnd = randomFactory;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        VectorFieldTypeInformation<DoubleVector> vectorFieldTypeInformation = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, this.dim);
        ArrayList<DoubleVector> arrayList = new ArrayList<DoubleVector>(this.size);
        Random random = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < this.size; ++i) {
            arrayList.add(VectorUtil.randomVector(DoubleVector.FACTORY, this.dim, random));
        }
        return MultipleObjectsBundle.makeSimple(vectorFieldTypeInformation, arrayList);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SEED_ID = new OptionID("dbc.genseed", "Seed for randomly generating vectors");
        public static final OptionID DIM_ID = new OptionID("dbc.dim", "Dimensionality of the vectors to generate.");
        public static final OptionID SIZE_ID = new OptionID("dbc.size", "Database size to generate.");
        int dim = -1;
        int size = -1;
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            IntParameter intParameter;
            super.makeOptions(parameterization);
            this.configFilters(parameterization);
            IntParameter intParameter2 = new IntParameter(DIM_ID);
            if (parameterization.grab(intParameter2)) {
                this.dim = intParameter2.intValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(SIZE_ID))) {
                this.size = intParameter.intValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RandomDoubleVectorDatabaseConnection makeInstance() {
            return new RandomDoubleVectorDatabaseConnection(this.dim, this.size, this.rnd, this.filters);
        }
    }
}

