/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import java.lang.reflect.Field;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static <V extends NumberVector> NumberVector.Factory<V> guessFactory(SimpleTypeInformation<V> simpleTypeInformation) {
        NumberVector.Factory factory = null;
        if (simpleTypeInformation instanceof VectorTypeInformation) {
            factory = (NumberVector.Factory)((VectorTypeInformation)simpleTypeInformation).getFactory();
        }
        if (factory == null) {
            try {
                Field field = simpleTypeInformation.getRestrictionClass().getField("FACTORY");
                factory = (NumberVector.Factory)field.get(null);
            }
            catch (Exception exception) {
                LoggingUtil.warning("Cannot determine factory for type " + simpleTypeInformation.getRestrictionClass(), exception);
            }
        }
        return factory;
    }

    public static int findLabelColumn(MultipleObjectsBundle multipleObjectsBundle) {
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            if (!TypeUtil.GUESSED_LABEL.isAssignableFromType(multipleObjectsBundle.meta(i))) continue;
            return i;
        }
        return -1;
    }

    public static int findLabelColumn(BundleMeta bundleMeta) {
        for (int i = 0; i < bundleMeta.size(); ++i) {
            if (!TypeUtil.GUESSED_LABEL.isAssignableFromType((TypeInformation)bundleMeta.get(i))) continue;
            return i;
        }
        return -1;
    }
}

