/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.parser.AbstractStreamingParser;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ClusteringVectorParser
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(ClusteringVectorParser.class);
    int numterms;
    protected BundleMeta meta;
    BundleStreamSource.Event nextevent;
    Clustering<Model> curclu;
    LabelList curlbl;
    TIntArrayList buf1 = new TIntArrayList();
    DBIDRange range = null;
    ArrayList<String> lbl = new ArrayList();
    boolean haslbl;

    public ClusteringVectorParser(CSVReaderFormat cSVReaderFormat) {
        super(cSVReaderFormat);
    }

    @Override
    public void initStream(InputStream inputStream) {
        super.initStream(inputStream);
        this.range = null;
        this.haslbl = false;
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event event = this.nextevent;
            this.nextevent = null;
            return event;
        }
        try {
            if (this.reader.nextLineExceptComments()) {
                Object object;
                int n;
                this.buf1.clear();
                this.lbl.clear();
                TIntIntHashMap tIntIntHashMap = new TIntIntHashMap();
                TIntObjectHashMap<ArrayModifiableDBIDs> tIntObjectHashMap = new TIntObjectHashMap<ArrayModifiableDBIDs>();
                String string = null;
                while (this.tokenizer.valid()) {
                    block16: {
                        try {
                            n = (int)this.tokenizer.getLongBase10();
                            this.buf1.add(n);
                            if (!tIntIntHashMap.increment(n)) {
                                tIntIntHashMap.put(n, 1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = this.tokenizer.getSubstring();
                            this.lbl.add((String)object);
                            if (string != null) break block16;
                            string = object;
                        }
                    }
                    this.tokenizer.advance();
                }
                if (string == null) {
                    string = "Cluster";
                }
                int n2 = n = this.range == null ? 1 : 0;
                if (this.range == null) {
                    this.range = DBIDUtil.generateStaticDBIDRange(this.buf1.size());
                }
                if (this.buf1.size() != this.range.size()) {
                    throw new AbortException("Clusterings do not contain the same number of elements!");
                }
                this.curclu = new Clustering(string, string);
                object = tIntIntHashMap.iterator();
                while (object.hasNext()) {
                    object.advance();
                    if (object.value() <= 0) continue;
                    tIntObjectHashMap.put(object.key(), DBIDUtil.newArray(object.value()));
                }
                object = this.range.iter();
                for (int i = 0; i < this.buf1.size(); ++i) {
                    ((ModifiableDBIDs)tIntObjectHashMap.get(this.buf1.get(i))).add(object.seek(i));
                }
                TIntObjectIterator tIntObjectIterator = tIntObjectHashMap.iterator();
                while (tIntObjectIterator.hasNext()) {
                    tIntObjectIterator.advance();
                    this.curclu.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)tIntObjectIterator.value(), ClusterModel.CLUSTER));
                }
                if (!this.haslbl && this.lbl.size() > 0) {
                    this.haslbl = true;
                    n = 1;
                }
                this.curlbl = LabelList.make(this.lbl);
                if (n != 0) {
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                return BundleStreamSource.Event.NEXT_OBJECT;
            }
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    @Override
    public Object data(int n) {
        if (n == 0) {
            return this.curclu;
        }
        if (n == 1) {
            return this.curlbl;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.meta = new BundleMeta(this.haslbl ? 2 : 1);
            this.meta.add(TypeUtil.CLUSTERING);
            if (this.haslbl) {
                this.meta.add(TypeUtil.LABELLIST);
            }
        }
        return this.meta;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractStreamingParser.Parameterizer {
        @Override
        protected ClusteringVectorParser makeInstance() {
            return new ClusteringVectorParser(this.format);
        }
    }
}

