/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.MTreeSplit;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Random;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="VLDB'97, Proceedings of 23rd International Conference on Very Large Data Bases, August 25-29, 1997, Athens, Greece", url="http://www.vldb.org/conf/1997/P426.PDF")
public class RandomSplit<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry>
extends MTreeSplit<O, N, E> {
    private Random random;

    public RandomSplit(RandomFactory randomFactory) {
        this.random = randomFactory.getSingleThreadedRandom();
    }

    @Override
    public Assignments<E> split(AbstractMTree<O, N, E, ?> abstractMTree, N n) {
        int n2 = ((AbstractNode)n).getNumEntries();
        int n3 = this.random.nextInt(n2);
        int n4 = this.random.nextInt(n2 - 1);
        if (n4 >= n3) {
            ++n4;
        }
        DBID dBID = ((MTreeEntry)((AbstractNode)n).getEntry(n3)).getRoutingObjectID();
        DBID dBID2 = ((MTreeEntry)((AbstractNode)n).getEntry(n4)).getRoutingObjectID();
        return this.balancedPartition(abstractMTree, n, dBID, dBID2);
    }

    public static class Parameterizer<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry>
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("mtree.randomsplit.random", "Random generator / seed for the randomized split.");
        RandomFactory rnd = RandomFactory.DEFAULT;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            RandomParameter randomParameter = new RandomParameter(RANDOM_ID);
            if (parameterization.grab(randomParameter)) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RandomSplit<O, N, E> makeInstance() {
            return new RandomSplit(this.rnd);
        }
    }
}

