/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert.AbstractPartialReinsert;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.Arrays;
import java.util.Collections;

@Reference(authors="N. Beckmann, H.-P. Kriegel, R. Schneider, B. Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proceedings of the 1990 ACM SIGMOD International Conference on Management of Data, Atlantic City, NJ, May 23-25, 1990", url="http://dx.doi.org/10.1145/93597.98741")
public class FarReinsert
extends AbstractPartialReinsert {
    public FarReinsert(double d, SpatialPrimitiveDistanceFunction<?> spatialPrimitiveDistanceFunction) {
        super(d, spatialPrimitiveDistanceFunction);
    }

    @Override
    public <A> int[] computeReinserts(A a, ArrayAdapter<? extends SpatialComparable, ? super A> arrayAdapter, SpatialComparable spatialComparable) {
        int n;
        DoubleIntPair[] doubleIntPairArray = new DoubleIntPair[arrayAdapter.size(a)];
        DoubleVector doubleVector = new DoubleVector(SpatialUtil.centroid(spatialComparable));
        for (n = 0; n < doubleIntPairArray.length; ++n) {
            double d = this.distanceFunction.minDist(new DoubleVector(SpatialUtil.centroid(arrayAdapter.get(a, n))), doubleVector);
            doubleIntPairArray[n] = new DoubleIntPair(d, n);
        }
        Arrays.sort(doubleIntPairArray, Collections.reverseOrder());
        n = (int)(this.reinsertAmount * (double)doubleIntPairArray.length);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = doubleIntPairArray[i].second;
        }
        return nArray;
    }

    public static class Parameterizer
    extends AbstractPartialReinsert.Parameterizer {
        @Override
        protected FarReinsert makeInstance() {
            return new FarReinsert(this.reinsertAmount, this.distanceFunction);
        }
    }
}

