/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMeanVarianceEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class ExponentialMOMEstimator
extends AbstractMeanVarianceEstimator<ExponentialDistribution> {
    public static final ExponentialMOMEstimator STATIC = new ExponentialMOMEstimator();

    private ExponentialMOMEstimator() {
    }

    @Override
    public ExponentialDistribution estimateFromMeanVariance(MeanVariance meanVariance) {
        double d = meanVariance.getMean();
        if (!(d > 0.0)) {
            throw new ArithmeticException("Data with non-positive mean cannot be exponential distributed.");
        }
        return new ExponentialDistribution(1.0 / d);
    }

    @Override
    public Class<? super ExponentialDistribution> getDistributionClass() {
        return ExponentialDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExponentialMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

